/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.LazyTestsToRun;

public class ForkedBooter {
    private static final long SYSTEM_EXIT_TIMEOUT = 30000L;

    public static void main(String[] args) throws Throwable {
        PrintStream originalOut = System.out;
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            boolean readTestsFromInputStream = providerConfiguration.isReadTestsFromInStream();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            ClassLoader testClassLoader = classpathConfiguration.createForkingTestClassLoader(startupConfiguration.isManifestOnlyJarRequestedAndUsable());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue(testClassLoader) : (readTestsFromInputStream ? new LazyTestsToRun(System.in, testClassLoader, originalOut) : null);
            try {
                ForkedBooter.runSuitesInProcess(testSet, testClassLoader, startupConfiguration, providerConfiguration, originalOut);
            }
            catch (InvocationTargetException t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t.getTargetException());
                StringBuffer stringBuffer = new StringBuffer();
                ForkingRunListener.encode((StringBuffer)stringBuffer, (StackTraceWriter)stackTraceWriter, (boolean)false);
                originalOut.println("X,0," + stringBuffer.toString());
            }
            catch (Throwable t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t);
                StringBuffer stringBuffer = new StringBuffer();
                ForkingRunListener.encode((StringBuffer)stringBuffer, (StackTraceWriter)stackTraceWriter, (boolean)false);
                originalOut.println("X,0," + stringBuffer.toString());
            }
            originalOut.println("Z,0,BYE!");
            originalOut.flush();
            ForkedBooter.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            ForkedBooter.exit(1);
        }
    }

    private static void exit(int returnCode) {
        ForkedBooter.launchLastDitchDaemonShutdownThread(returnCode);
        System.exit(returnCode);
    }

    private static RunResult runSuitesInProcess(Object testSet, ClassLoader testsClassLoader, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) throws SurefireExecutionException, TestSetFailedException, InvocationTargetException {
        ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object factory = ForkedBooter.createForkingReporterFactory(surefireReflector, providerConfiguration, originalSystemOut);
        return ProviderFactory.invokeProvider(testSet, testsClassLoader, surefireClassLoader, factory, providerConfiguration, true, startupConfiguration, false);
    }

    private static Object createForkingReporterFactory(SurefireReflector surefireReflector, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) {
        Boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return surefireReflector.createForkingReporterFactory(trimStackTrace, originalSystemOut);
    }

    private static void launchLastDitchDaemonShutdownThread(final int returnCode) {
        Thread lastExit = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    Runtime.getRuntime().halt(returnCode);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        lastExit.setDaemon(true);
        lastExit.start();
    }
}

