/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.TestsToRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyTestsToRun
extends TestsToRun {
    private final List<Class> workQueue = new ArrayList<Class>();
    private BufferedReader inputReader;
    private boolean streamClosed = false;
    private PrintStream originalOutStream;

    public LazyTestsToRun(InputStream testSource, PrintStream originalOutStream) {
        super(Collections.emptyList());
        this.originalOutStream = originalOutStream;
        this.inputReader = new BufferedReader(new InputStreamReader(testSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWorkItem(String className) {
        List<Class> list = this.workQueue;
        synchronized (list) {
            this.workQueue.add(ReflectionUtils.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)className));
        }
    }

    protected void requestNextTest() {
        StringBuilder sb = new StringBuilder();
        sb.append('N').append(",0,want more!\n");
        this.originalOutStream.print(sb.toString());
    }

    public Iterator<Class> iterator() {
        return new BlockingIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("LazyTestsToRun ");
        List<Class> list = this.workQueue;
        synchronized (list) {
            sb.append("(more items expected: ").append(!this.streamClosed).append("): ");
            sb.append(this.workQueue);
        }
        return sb.toString();
    }

    public boolean allowEagerReading() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockingIterator
    implements Iterator<Class> {
        private int lastPos = -1;

        private BlockingIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            int nextPos = this.lastPos + 1;
            List list = LazyTestsToRun.this.workQueue;
            synchronized (list) {
                if (LazyTestsToRun.this.workQueue.size() > nextPos) {
                    return true;
                }
                if (this.needsToWaitForInput(nextPos)) {
                    String nextClassName;
                    LazyTestsToRun.this.requestNextTest();
                    try {
                        nextClassName = LazyTestsToRun.this.inputReader.readLine();
                    }
                    catch (IOException e) {
                        LazyTestsToRun.this.streamClosed = true;
                        return false;
                    }
                    if (null == nextClassName) {
                        LazyTestsToRun.this.streamClosed = true;
                    } else {
                        LazyTestsToRun.this.addWorkItem(nextClassName);
                    }
                }
                return LazyTestsToRun.this.workQueue.size() > nextPos;
            }
        }

        private boolean needsToWaitForInput(int nextPos) {
            return LazyTestsToRun.this.workQueue.size() == nextPos && !LazyTestsToRun.this.streamClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class next() {
            List list = LazyTestsToRun.this.workQueue;
            synchronized (list) {
                return (Class)LazyTestsToRun.this.workQueue.get(++this.lastPos);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

