/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.output;

import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.report.ForkingConsoleReporter;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkingStreamConsumer
implements StreamConsumer {
    private static int STANDARD_PREFIX_LENGTH = "@SL".length();
    private static int HEADING_PREFIX_LENGTH = "@HL".length();
    private static int FOOTER_PREFIX_LENGTH = "@FL".length();
    private OutputConsumer outputConsumer;

    public ForkingStreamConsumer(OutputConsumer outputConsumer) {
        this.outputConsumer = outputConsumer;
    }

    public void consumeLine(String line) {
        if (line.startsWith("@HL")) {
            this.outputConsumer.consumeHeaderLine(line.substring(HEADING_PREFIX_LENGTH));
        } else if (line.startsWith("@SL")) {
            String message = line.substring(STANDARD_PREFIX_LENGTH);
            if (ForkingConsoleReporter.isTestSetStartingMessage((String)message)) {
                this.outputConsumer.testSetStarting(ForkingConsoleReporter.parseTestSetStartingMessage((String)message));
            } else if (ForkingConsoleReporter.isTestSetCompletedMessage((String)message)) {
                this.outputConsumer.testSetCompleted();
            }
            this.outputConsumer.consumeMessageLine(message);
        } else if (line.startsWith("@FL")) {
            this.outputConsumer.consumeFooterLine(line.substring(FOOTER_PREFIX_LENGTH));
        } else {
            this.outputConsumer.consumeOutputLine(line);
        }
    }
}

