/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireStarter;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.suite.RunResult;

public class ForkedBooter {
    public static void main(String[] args) throws Throwable {
        try {
            RunResult runResult;
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration booterConfiguration = booterDeserializer.deserialize();
            StartupConfiguration providerConfiguration = booterDeserializer.getProviderConfiguration();
            SurefireStarter booter = new SurefireStarter(providerConfiguration, booterConfiguration);
            Object forkedTestSet = booterConfiguration.getTestForFork();
            Properties p = booterConfiguration.getProviderProperties();
            if (forkedTestSet != null) {
                runResult = booter.runSuitesInProcess(forkedTestSet);
                booter.updateResultsProperties(runResult, p);
                SystemPropertyManager.writePropertiesFile(surefirePropertiesFile, "surefire", p);
            } else {
                runResult = booter.runSuitesInProcess();
            }
            int result = booter.processRunCount(runResult);
            System.exit(result);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

