/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.maven.surefire.util.ReflectionUtils;

public class TypeEncodedValue {
    private final String type;
    private final String value;

    public TypeEncodedValue(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public boolean isTypeClass() {
        return Class.class.getName().equals(this.type);
    }

    public Object getDecodedValue() {
        return this.getDecodedValue(Thread.currentThread().getContextClassLoader());
    }

    public Object getDecodedValue(ClassLoader classLoader) {
        if (this.type.trim().isEmpty()) {
            return null;
        }
        if (this.type.equals(String.class.getName())) {
            return this.value;
        }
        if (this.isTypeClass()) {
            return ReflectionUtils.loadClass((ClassLoader)classLoader, (String)this.value);
        }
        if (this.type.equals(File.class.getName())) {
            return new File(this.value);
        }
        if (this.type.equals(Boolean.class.getName())) {
            return Boolean.valueOf(this.value);
        }
        if (this.type.equals(Integer.class.getName())) {
            return Integer.valueOf(this.value);
        }
        if (this.type.equals(Properties.class.getName())) {
            Properties result = new Properties();
            try {
                result.load(new ByteArrayInputStream(this.value.getBytes(StandardCharsets.ISO_8859_1)));
                return result;
            }
            catch (IOException e) {
                throw new IllegalStateException("bug in property conversion", e);
            }
        }
        throw new IllegalArgumentException("Unknown parameter type: " + this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEncodedValue that = (TypeEncodedValue)o;
        return this.equalsType(that) && this.equalsValue(that);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    private boolean equalsType(TypeEncodedValue that) {
        return this.type == null ? that.type == null : this.type.equals(that.type);
    }

    private boolean equalsValue(TypeEncodedValue that) {
        return this.value == null ? that.value == null : this.value.equals(that.value);
    }
}

