/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.junitcore.ConfigurableParallelComputer;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitCoreWrapper {
    JUnitCoreWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(TestsToRun testsToRun, JUnitCoreParameters jUnitCoreParameters, List<RunListener> listeners, Filter filter) throws TestSetFailedException {
        Computer computer = JUnitCoreWrapper.getComputer(jUnitCoreParameters);
        JUnitCore junitCore = JUnitCoreWrapper.createJUnitCore(listeners);
        try {
            if (testsToRun.allowEagerReading()) {
                JUnitCoreWrapper.executeEager(testsToRun, filter, computer, junitCore);
            } else {
                JUnitCoreWrapper.exeuteLazy(testsToRun, filter, computer, junitCore);
            }
        }
        finally {
            JUnitCoreWrapper.closeIfConfigurable(computer);
        }
    }

    private static JUnitCore createJUnitCore(List<RunListener> listeners) {
        JUnitCore junitCore = new JUnitCore();
        for (RunListener runListener : listeners) {
            junitCore.addListener(runListener);
        }
        return junitCore;
    }

    private static void executeEager(TestsToRun testsToRun, Filter filter, Computer computer, JUnitCore junitCore) throws TestSetFailedException {
        Class[] tests = testsToRun.getLocatedClasses();
        JUnitCoreWrapper.createReqestAndRun(filter, computer, junitCore, tests);
    }

    private static void exeuteLazy(TestsToRun testsToRun, Filter filter, Computer computer, JUnitCore junitCore) throws TestSetFailedException {
        Iterator classIter = testsToRun.iterator();
        while (classIter.hasNext()) {
            JUnitCoreWrapper.createReqestAndRun(filter, computer, junitCore, new Class[]{(Class)classIter.next()});
        }
    }

    private static void createReqestAndRun(Filter filter, Computer computer, JUnitCore junitCore, Class<?>[] classesToRun) throws TestSetFailedException {
        Request req = Request.classes((Computer)computer, (Class[])classesToRun);
        if (filter != null && (req = new FilteringRequest(req, filter)).getRunner() == null) {
            return;
        }
        Result run = junitCore.run(req);
        JUnit4RunListener.rethrowAnyTestMechanismFailures(run);
    }

    private static void closeIfConfigurable(Computer computer) throws TestSetFailedException {
        if (computer instanceof ConfigurableParallelComputer) {
            try {
                ((ConfigurableParallelComputer)computer).close();
            }
            catch (ExecutionException e) {
                throw new TestSetFailedException((Throwable)e);
            }
        }
    }

    private static Computer getComputer(JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        if (jUnitCoreParameters.isNoThreading()) {
            return new Computer();
        }
        return JUnitCoreWrapper.getConfigurableParallelComputer(jUnitCoreParameters);
    }

    private static Computer getConfigurableParallelComputer(JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        if (jUnitCoreParameters.isUseUnlimitedThreads().booleanValue()) {
            return new ConfigurableParallelComputer();
        }
        return new ConfigurableParallelComputer(jUnitCoreParameters.isParallelClasses() | jUnitCoreParameters.isParallelBoth(), jUnitCoreParameters.isParallelMethod() | jUnitCoreParameters.isParallelBoth(), jUnitCoreParameters.getThreadCount(), (boolean)jUnitCoreParameters.isPerCoreThreadCount());
    }

    private static class FilteringRequest
    extends Request {
        private Runner filteredRunner;

        public FilteringRequest(Request req, Filter filter) {
            try {
                Runner runner = req.getRunner();
                filter.apply((Object)runner);
                this.filteredRunner = runner;
            }
            catch (NoTestsRemainException e) {
                this.filteredRunner = null;
            }
        }

        public Runner getRunner() {
            return this.filteredRunner;
        }
    }
}

