/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ConsoleOutputReceiverForCurrentThread;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;

class TestMethod
implements ConsoleOutputReceiver {
    private final ReportEntry description;
    private final TestSet testSet;
    private final long startTime;
    private long endTime;
    private volatile ReportEntry testFailure;
    private volatile ReportEntry testError;
    private volatile ReportEntry ignored;
    private static final InheritableThreadLocal<TestMethod> TEST_METHOD = new InheritableThreadLocal();
    private volatile LogicalStream output;

    public TestMethod(ReportEntry description, TestSet testSet) {
        this.description = description;
        this.testSet = testSet;
        this.startTime = System.currentTimeMillis();
    }

    public void testFinished() {
        this.setEndTime();
    }

    public void testIgnored(ReportEntry description) {
        this.ignored = description;
        this.setEndTime();
    }

    public void testFailure(ReportEntry failure) {
        this.testFailure = failure;
        this.setEndTime();
    }

    public void testError(ReportEntry failure) {
        this.testError = failure;
        this.setEndTime();
    }

    private void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public int getElapsed() {
        return this.endTime > 0L ? (int)(this.endTime - this.startTime) : 0;
    }

    public void replay(RunListener reporter) {
        if (this.ignored != null) {
            reporter.testSkipped(this.createReportEntry(this.ignored));
            return;
        }
        ReportEntry descriptionReport = this.createReportEntry(this.description);
        reporter.testStarting(descriptionReport);
        if (this.output != null) {
            this.output.writeDetails((ConsoleOutputReceiver)reporter);
        }
        if (this.testFailure != null) {
            reporter.testFailed(this.createReportEntry(this.testFailure));
        } else if (this.testError != null) {
            reporter.testError(this.createReportEntry(this.testError));
        } else {
            reporter.testSucceeded(descriptionReport);
        }
    }

    private ReportEntry createReportEntry(ReportEntry reportEntry) {
        return new CategorizedReportEntry(reportEntry.getSourceName(), reportEntry.getName(), reportEntry.getGroup(), reportEntry.getStackTraceWriter(), Integer.valueOf(this.getElapsed()), reportEntry.getMessage());
    }

    public void attachToThread() {
        TEST_METHOD.set(this);
        ConsoleOutputReceiverForCurrentThread.set((ConsoleOutputReceiver)this);
    }

    public void detachFromCurrentThread() {
        TEST_METHOD.remove();
        ConsoleOutputReceiverForCurrentThread.remove();
    }

    public static TestMethod getThreadTestMethod() {
        return (TestMethod)TEST_METHOD.get();
    }

    public LogicalStream getLogicalStream() {
        if (this.output == null) {
            this.output = new LogicalStream();
        }
        return this.output;
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        this.getLogicalStream().write(stdout, buf, off, len);
    }

    public TestSet getTestSet() {
        return this.testSet;
    }
}

