/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class DemultiplexingRunListener
extends RunListener {
    private final Map<String, RecordingRunListener> classList = new HashMap<String, RecordingRunListener>();
    private final RunListener realtarget;

    public DemultiplexingRunListener(RunListener realtarget) {
        this.realtarget = realtarget;
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result outerResult) throws Exception {
        for (RecordingRunListener classReport : this.classList.values()) {
            classReport.replay(this.realtarget);
        }
    }

    public void testStarted(Description description) throws Exception {
        this.getOrCreateClassReport(description).testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        this.getClassReport(description).testFinished(description);
    }

    public void testFailure(Failure failure) throws Exception {
        this.getClassReport(failure.getDescription()).testFailure(failure);
    }

    public void testAssumptionFailure(Failure failure) {
        this.getClassReport(failure.getDescription()).testAssumptionFailure(failure);
    }

    public void testIgnored(Description description) throws Exception {
        this.getClassReport(description).testIgnored(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecordingRunListener getClassReport(Description description) {
        Map<String, RecordingRunListener> map = this.classList;
        synchronized (map) {
            return this.classList.get(description.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordingRunListener getOrCreateClassReport(Description description) throws Exception {
        RecordingRunListener result;
        Map<String, RecordingRunListener> map = this.classList;
        synchronized (map) {
            result = this.classList.get(description.getClassName());
            if (result == null) {
                result = new RecordingRunListener();
                result.testRunStarted(description);
                this.classList.put(description.getClassName(), result);
            }
        }
        return result;
    }

    public class RecordingRunListener
    extends RunListener {
        private volatile Description testRunStarted;
        private final List<Description> testStarted = Collections.synchronizedList(new ArrayList());
        private final List<Description> testFinished = Collections.synchronizedList(new ArrayList());
        private final List<Failure> testFailure = Collections.synchronizedList(new ArrayList());
        private final List<Failure> testAssumptionFailure = Collections.synchronizedList(new ArrayList());
        private final List<Description> testIgnored = Collections.synchronizedList(new ArrayList());
        private final Result resultForThisClass = new Result();
        private final RunListener classRunListener = this.resultForThisClass.createListener();

        public void testRunStarted(Description description) throws Exception {
            this.testRunStarted = description;
        }

        public void testRunFinished(Result result) throws Exception {
            throw new IllegalStateException("This method should not be called on the recorder");
        }

        public void testStarted(Description description) throws Exception {
            this.testStarted.add(description);
            this.classRunListener.testStarted(description);
        }

        public void testFinished(Description description) throws Exception {
            this.testFinished.add(description);
            this.classRunListener.testFinished(description);
        }

        public void testFailure(Failure failure) throws Exception {
            this.testFailure.add(failure);
            this.classRunListener.testFailure(failure);
        }

        public void testAssumptionFailure(Failure failure) {
            this.testAssumptionFailure.add(failure);
        }

        public void testIgnored(Description description) throws Exception {
            this.testIgnored.add(description);
        }

        public void replay(RunListener target) throws Exception {
            target.testRunStarted(this.testRunStarted);
            for (Description description : this.testStarted) {
                target.testStarted(description);
            }
            for (Failure failure : this.testFailure) {
                target.testFailure(failure);
            }
            for (Description description : this.testIgnored) {
                target.testIgnored(description);
            }
            for (Failure failure : this.testAssumptionFailure) {
                target.testAssumptionFailure(failure);
            }
            for (Description description : this.testFinished) {
                target.testFinished(description);
            }
            target.testRunFinished(this.resultForThisClass);
        }
    }
}

