/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.surefire.junitcore.ConcurrentReportingRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.experimental.ParallelComputer;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

class JUnitCoreTestSet {
    private final Class testClass;
    private static final String className = "org.jdogma.junit.ConfigurableParallelComputer";

    public String getName() {
        return this.testClass.getName();
    }

    Class getTestClass() {
        return this.testClass;
    }

    protected JUnitCoreTestSet(Class testClasses) {
        this.testClass = testClasses;
    }

    public void execute(ReporterManagerFactory reportManager, JUnitCoreParameters JUnitCoreParameters2) throws TestSetFailedException {
        Class[] classes = new Class[]{this.testClass};
        JUnitCoreTestSet.execute(classes, reportManager, JUnitCoreParameters2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Class[] classes, ReporterManagerFactory reporterManagerFactory, JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        ConcurrentReportingRunListener listener = ConcurrentReportingRunListener.createInstance(reporterManagerFactory, jUnitCoreParameters.isParallelClasses(), jUnitCoreParameters.isParallelBoth());
        Computer computer = JUnitCoreTestSet.getComputer(jUnitCoreParameters);
        try {
            JUnitCoreTestSet.runJunitCore(classes, computer, listener);
        }
        finally {
            JUnitCoreTestSet.closeIfConfigurable(computer);
        }
    }

    private static void closeIfConfigurable(Computer computer) throws TestSetFailedException {
        if (computer.getClass().getName().startsWith(className)) {
            try {
                Class<?> cpcClass = Class.forName(className);
                Method method = cpcClass.getMethod("close", new Class[0]);
                method.invoke((Object)computer, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new TestSetFailedException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new TestSetFailedException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new TestSetFailedException((Throwable)e);
            }
        }
    }

    private static Computer getComputer(JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        if (jUnitCoreParameters.isNoThreading()) {
            return new Computer();
        }
        return jUnitCoreParameters.isConfigurableParallelComputerPresent() != false ? JUnitCoreTestSet.getConfigurableParallelComputer(jUnitCoreParameters) : JUnitCoreTestSet.getParallelComputer(jUnitCoreParameters);
    }

    private static Computer getParallelComputer(JUnitCoreParameters JUnitCoreParameters2) {
        if (JUnitCoreParameters2.isUseUnlimitedThreads().booleanValue()) {
            return new ParallelComputer(true, true);
        }
        return new ParallelComputer(JUnitCoreParameters2.isParallelClasses(), JUnitCoreParameters2.isParallelMethod());
    }

    private static Computer getConfigurableParallelComputer(JUnitCoreParameters JUnitCoreParameters2) throws TestSetFailedException {
        try {
            Class<?> cpcClass = Class.forName(className);
            if (JUnitCoreParameters2.isUseUnlimitedThreads().booleanValue()) {
                Constructor<?> constructor = cpcClass.getConstructor(new Class[0]);
                return (Computer)constructor.newInstance(new Object[0]);
            }
            Constructor<?> constructor = cpcClass.getConstructor(Boolean.TYPE, Boolean.TYPE, Integer.class, Boolean.TYPE);
            return (Computer)constructor.newInstance(JUnitCoreParameters2.isParallelClasses(), JUnitCoreParameters2.isParallelMethod(), JUnitCoreParameters2.getThreadCount(), JUnitCoreParameters2.isPerCoreThreadCount());
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runJunitCore(Class[] classes, Computer computer, RunListener real) throws TestSetFailedException {
        JUnitCore junitCore = new JUnitCore();
        junitCore.addListener(real);
        try {
            junitCore.run(computer, classes);
        }
        finally {
            junitCore.removeListener(real);
        }
    }
}

