/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreTestSet;
import org.apache.maven.surefire.junitcore.TestsToRun;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.SurefireDirectoryScanner;

public class JUnitCoreDirectoryTestSuite
implements SurefireTestSuite {
    private final SurefireDirectoryScanner directoryScanner;
    private TestsToRun testsToRun;
    protected Map testSets;
    private final JUnitCoreParameters jUnitCoreParameters;

    public JUnitCoreDirectoryTestSuite(File basedir, ArrayList includes, ArrayList excludes, Properties properties) {
        this.directoryScanner = new SurefireDirectoryScanner(basedir, (List)includes, (List)excludes);
        this.jUnitCoreParameters = new JUnitCoreParameters(properties);
    }

    public void execute(ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testsToRun == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        JUnitCoreTestSet.execute(this.testsToRun.getLocatedClasses(), reporterManagerFactory, this.jUnitCoreParameters);
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testsToRun == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        JUnitCoreTestSet testSet = this.testsToRun.getTestSet(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        testSet.execute(reporterManagerFactory, this.jUnitCoreParameters);
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        Class[] locatedClasses = this.directoryScanner.locateTestClasses(classLoader);
        this.testsToRun = new TestsToRun(locatedClasses);
        return this.testsToRun.getTestSets();
    }

    public int getNumTests() {
        if (this.testsToRun == null) {
            throw new IllegalStateException("You must call locateTestSets before calling getNumTests");
        }
        return this.testsToRun.size();
    }
}

