/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.report.ReporterManager;

public class LogicalStream {
    private final List<Entry> output = new ArrayList<Entry>();

    public synchronized void write(boolean stdout, byte[] b, int off, int len) {
        Entry entry = new Entry(stdout, b, off, len);
        if (!entry.isBlankLine()) {
            this.output.add(entry);
        }
    }

    public void writeToConsole(ReporterManager reporter) {
        for (Entry entry : this.output) {
            entry.writeToConsole(reporter);
        }
    }

    public String getOutput(boolean stdOut) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.output) {
            if (stdOut != entry.isStdout()) continue;
            entry.writeTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    class Entry {
        final boolean stdout;
        final String value;

        Entry(boolean stdout, byte[] b, int off, int len) {
            this.stdout = stdout;
            this.value = new String(b, off, len).intern();
        }

        public boolean isStdout() {
            return this.stdout;
        }

        public void writeTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.value);
        }

        public void writeToConsole(ReporterManager reporter) {
            reporter.writeConsoleMessage(this.value);
        }

        public String toString() {
            return this.value;
        }

        public boolean isBlankLine() {
            return "\n".equals(this.value);
        }
    }
}

