/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.surefire.junitcore.JUnitCoreStackTraceWriter;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestMethod {
    private final Description description;
    private volatile Failure testFailure;
    private volatile Failure testAssumptionFailure;
    private volatile Description ignored;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private static final InheritableThreadLocal<TestMethod> testMethod = new InheritableThreadLocal();
    private volatile LogicalStream output;

    public TestMethod(Description description) {
        this.description = description;
    }

    public void testFinished() throws Exception {
    }

    public void testIgnored(Description description) throws Exception {
        this.ignored = description;
    }

    public void testFailure(Failure failure) throws Exception {
        this.testFailure = failure;
    }

    public void testAssumptionFailure(Failure failure) {
        this.testAssumptionFailure = failure;
    }

    public void replay(ReporterManager reporter) throws Exception {
        if (this.ignored != null) {
            reporter.testSkipped(this.createReportEntry("testSkipped"));
            return;
        }
        reporter.testStarting(this.createReportEntry("testStarting"));
        if (this.output != null) {
            this.output.writeToConsole(reporter);
        }
        if (this.testFailure != null) {
            ReportEntry report = this.createFailureEntry(this.testFailure, "executeException");
            if (this.testFailure.getException() instanceof AssertionError) {
                reporter.testFailed(report, this.getStdout(), this.getStdErr());
            } else {
                reporter.testError(report, this.getStdout(), this.getStdErr());
            }
        } else if (this.testAssumptionFailure == null) {
            reporter.testSucceeded(this.createReportEntry("testSuccessful"));
        }
    }

    private ReportEntry createReportEntry(String rawString2) {
        String rawString = bundle.getString(rawString2);
        return new ReportEntry(this.description.getTestClass().getCanonicalName(), this.description.getDisplayName(), rawString);
    }

    private ReportEntry createFailureEntry(Failure failure, String rawString2) {
        String rawString = bundle.getString(rawString2);
        return new ReportEntry(failure.getDescription().getTestClass().getCanonicalName(), failure.getTestHeader(), rawString, (StackTraceWriter)new JUnitCoreStackTraceWriter(failure));
    }

    public void attachToThread() {
        testMethod.set(this);
    }

    public static void detachFromCurrentThread() {
        testMethod.remove();
    }

    public static TestMethod getThreadTestMethod() {
        return (TestMethod)testMethod.get();
    }

    public LogicalStream getLogicalStream() {
        if (this.output == null) {
            this.output = new LogicalStream();
        }
        return this.output;
    }

    private String getStdout() {
        return this.output != null ? this.output.getOutput(true) : "";
    }

    private String getStdErr() {
        return this.output != null ? this.output.getOutput(false) : "";
    }

    public static void fillTestCountMap(Description description, Map<Class, TestSet> methodCount) {
        ArrayList children = description.getChildren();
        TestSet testSet = new TestSet(description);
        Class itemTestClass = null;
        for (Description item : children) {
            if (item.isTest()) {
                testSet.incrementTestMethodCount();
                if (itemTestClass != null) continue;
                itemTestClass = item.getTestClass();
                continue;
            }
            if (item.getChildren().size() <= 0) continue;
            TestMethod.fillTestCountMap(item, methodCount);
        }
        if (itemTestClass != null) {
            methodCount.put(itemTestClass, testSet);
        }
    }
}

