/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testng.utils.FailFastEventsSingleton;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.TestsToRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGProvider
extends AbstractProvider {
    private final Map<String, String> providerProperties;
    private final ReporterConfiguration reporterConfiguration;
    private final ClassLoader testClassLoader;
    private final ScanResult scanResult;
    private final TestRequest testRequest;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final List<CommandLineOption> mainCliOptions;
    private final CommandReader commandsReader;
    private TestsToRun testsToRun;

    public TestNGProvider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? CommandReader.getReader().setShutdown(bootParams.getShutdown()) : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.providerProperties = bootParams.getProviderProperties();
        this.testRequest = bootParams.getTestRequest();
        this.reporterConfiguration = bootParams.getReporterConfiguration();
        this.scanResult = bootParams.getScanResult();
        this.mainCliOptions = bootParams.getMainCliOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopListener();
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        try {
            if (this.isTestNGXmlTestSuite(this.testRequest)) {
                if (this.commandsReader != null) {
                    this.commandsReader.awaitStarted();
                }
                TestNGXmlTestSuite testNGXmlTestSuite = this.newXmlSuite();
                testNGXmlTestSuite.locateTestSets();
                testNGXmlTestSuite.execute(reporter);
            } else {
                if (this.testsToRun == null) {
                    this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
                }
                if (this.commandsReader != null) {
                    this.registerShutdownListener(this.testsToRun);
                    this.commandsReader.awaitStarted();
                }
                TestNGDirectoryTestSuite suite = this.newDirectorySuite();
                suite.execute(this.testsToRun, reporter);
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    boolean isTestNGXmlTestSuite(TestRequest testSuiteDefinition) {
        List suiteXmlFiles = testSuiteDefinition.getSuiteXmlFiles();
        return !suiteXmlFiles.isEmpty() && !this.hasSpecificTests();
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopListener() {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                FailFastEventsSingleton.getInstance().setSkipOnNextTest();
            }
        });
    }

    private TestNGDirectoryTestSuite newDirectorySuite() {
        return new TestNGDirectoryTestSuite(this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.getTestFilter(), this.mainCliOptions, this.getSkipAfterFailureCount());
    }

    private TestNGXmlTestSuite newXmlSuite() {
        return new TestNGXmlTestSuite(this.testRequest.getSuiteXmlFiles(), this.testRequest.getTestSourceDirectory().toString(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.getSkipAfterFailureCount());
    }

    public Iterable<Class<?>> getSuites() {
        if (this.isTestNGXmlTestSuite(this.testRequest)) {
            return Collections.emptySet();
        }
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(null, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private boolean hasSpecificTests() {
        TestListResolver specificTestPatterns = this.testRequest.getTestListResolver();
        return !specificTestPatterns.isEmpty() && !specificTestPatterns.isWildcard();
    }

    private TestListResolver getTestFilter() {
        TestListResolver filter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testRequest.getTestListResolver());
        return filter.isWildcard() ? TestListResolver.getEmptyTestListResolver() : filter;
    }
}

