/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.http.LightweightHttpWagonAuthenticator;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.EncodingUtil;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;
import org.apache.maven.wagon.shared.http.HttpMessageUtils;
import org.codehaus.plexus.util.Base64;

public class LightweightHttpWagon
extends StreamWagon {
    private boolean preemptiveAuthentication;
    private HttpURLConnection putConnection;
    private Proxy proxy = Proxy.NO_PROXY;
    private static final Pattern IOEXCEPTION_MESSAGE_PATTERN = Pattern.compile("Server returned HTTP response code: (\\d\\d\\d) for URL: (.*)");
    public static final int MAX_REDIRECTS = 10;
    private boolean useCache;
    private Properties httpHeaders;
    private volatile LightweightHttpWagonAuthenticator authenticator;

    private String buildUrl(Resource resource) {
        return EncodingUtil.encodeURLToString((String)this.getRepository().getUrl(), (String)resource.getName());
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String visitingUrl = this.buildUrl(resource);
        ArrayList<String> visitedUrls = new ArrayList<String>();
        for (int redirectCount = 0; redirectCount < 10; ++redirectCount) {
            if (visitedUrls.contains(visitingUrl)) {
                throw new TransferFailedException("Cyclic http redirect detected. Aborting! " + visitingUrl);
            }
            visitedUrls.add(visitingUrl);
            URL url = null;
            try {
                url = new URL(visitingUrl);
            }
            catch (MalformedURLException e) {
                throw new ResourceDoesNotExistException("Invalid repository URL: " + e.getMessage(), (Throwable)e);
            }
            HttpURLConnection urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)url.openConnection(this.proxy);
            }
            catch (IOException e) {
                String message = HttpMessageUtils.formatTransferFailedMessage((String)visitingUrl, (int)-1, null, (ProxyInfo)this.getProxyInfo());
                throw new TransferFailedException(message, (Throwable)e);
            }
            try {
                boolean isDeflated;
                boolean isGZipped;
                urlConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
                if (!this.useCache) {
                    urlConnection.setRequestProperty("Pragma", "no-cache");
                }
                this.addHeaders(urlConnection);
                int responseCode = urlConnection.getResponseCode();
                String reasonPhrase = urlConnection.getResponseMessage();
                if (responseCode == 403 || responseCode == 401 || responseCode == 407) {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage((String)this.buildUrl(resource), (int)responseCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
                if (responseCode == 301 || responseCode == 302) {
                    visitingUrl = urlConnection.getHeaderField("Location");
                    continue;
                }
                InputStream is = urlConnection.getInputStream();
                String contentEncoding = urlConnection.getHeaderField("Content-Encoding");
                boolean bl = isGZipped = contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding);
                if (isGZipped) {
                    is = new GZIPInputStream(is);
                }
                boolean bl2 = isDeflated = contentEncoding != null && "deflate".equalsIgnoreCase(contentEncoding);
                if (isDeflated) {
                    is = new DeflaterInputStream(is);
                }
                inputData.setInputStream(is);
                resource.setLastModified(urlConnection.getLastModified());
                resource.setContentLength((long)urlConnection.getContentLength());
                break;
            }
            catch (FileNotFoundException e) {
                throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage((String)this.buildUrl(resource), (int)-1, null, (ProxyInfo)this.getProxyInfo()), (Throwable)e);
            }
            catch (IOException originalIOException) {
                throw this.convertHttpUrlConnectionException(originalIOException, urlConnection, this.buildUrl(resource));
            }
        }
    }

    private void addHeaders(HttpURLConnection urlConnection) {
        if (this.httpHeaders != null) {
            for (Object header : this.httpHeaders.keySet()) {
                urlConnection.setRequestProperty((String)header, this.httpHeaders.getProperty((String)header));
            }
        }
        this.setAuthorization(urlConnection);
    }

    private void setAuthorization(HttpURLConnection urlConnection) {
        if (this.preemptiveAuthentication && this.authenticationInfo != null && this.authenticationInfo.getUserName() != null) {
            String credentials = this.authenticationInfo.getUserName() + ":" + this.authenticationInfo.getPassword();
            String encoded = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
            urlConnection.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        try {
            URL url = new URL(this.buildUrl(resource));
            this.putConnection = (HttpURLConnection)url.openConnection(this.proxy);
            this.addHeaders(this.putConnection);
            this.putConnection.setRequestMethod("PUT");
            this.putConnection.setDoOutput(true);
            outputData.setOutputStream(this.putConnection.getOutputStream());
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void finishPutTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            String reasonPhrase = this.putConnection.getResponseMessage();
            int statusCode = this.putConnection.getResponseCode();
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case 401: 
                case 403: 
                case 407: {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage((String)this.buildUrl(resource), (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
                case 404: 
                case 410: {
                    throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage((String)this.buildUrl(resource), (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
                default: {
                    throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage((String)this.buildUrl(resource), (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            throw this.convertHttpUrlConnectionException(e, this.putConnection, this.buildUrl(resource));
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        ProxyInfo proxyInfo = this.getProxyInfo("http", this.getRepository().getHost());
        if (proxyInfo != null) {
            this.proxy = this.getProxy(proxyInfo);
            this.proxyInfo = proxyInfo;
        }
        this.authenticator.setWagon(this);
        boolean usePreemptiveAuthentication = Boolean.getBoolean("maven.wagon.http.preemptiveAuthentication") || Boolean.parseBoolean(this.repository.getParameter("preemptiveAuthentication")) || this.preemptiveAuthentication;
        this.setPreemptiveAuthentication(usePreemptiveAuthentication);
    }

    public PasswordAuthentication requestProxyAuthentication() {
        if (this.proxyInfo != null && this.proxyInfo.getUserName() != null) {
            String password = "";
            if (this.proxyInfo.getPassword() != null) {
                password = this.proxyInfo.getPassword();
            }
            return new PasswordAuthentication(this.proxyInfo.getUserName(), password.toCharArray());
        }
        return null;
    }

    public PasswordAuthentication requestServerAuthentication() {
        if (this.authenticationInfo != null && this.authenticationInfo.getUserName() != null) {
            String password = "";
            if (this.authenticationInfo.getPassword() != null) {
                password = this.authenticationInfo.getPassword();
            }
            return new PasswordAuthentication(this.authenticationInfo.getUserName(), password.toCharArray());
        }
        return null;
    }

    private Proxy getProxy(ProxyInfo proxyInfo) {
        return new Proxy(this.getProxyType(proxyInfo), this.getSocketAddress(proxyInfo));
    }

    private Proxy.Type getProxyType(ProxyInfo proxyInfo) {
        if ("SOCKS4".equals(proxyInfo.getType()) || "SOCKS_5".equals(proxyInfo.getType())) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    public SocketAddress getSocketAddress(ProxyInfo proxyInfo) {
        return InetSocketAddress.createUnresolved(proxyInfo.getHost(), proxyInfo.getPort());
    }

    public void closeConnection() throws ConnectionException {
        if (this.putConnection != null) {
            this.putConnection.disconnect();
        }
        this.authenticator.resetWagon();
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.buildUrl(new Resource(destinationDirectory));
        Resource resource = new Resource(destinationDirectory);
        inputData.setResource(resource);
        this.fillInputData(inputData);
        InputStream is = inputData.getInputStream();
        try {
            if (is == null) {
                throw new TransferFailedException(url + " - Could not open input stream for resource: '" + resource + "'");
            }
            List htmlFileList = HtmlFileListParser.parseFileList((String)url, (InputStream)is);
            is.close();
            is = null;
            List list = htmlFileList;
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("Failure transferring " + resource.getName(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            Resource resource = new Resource(resourceName);
            URL url = new URL(this.buildUrl(resource));
            HttpURLConnection headConnection = (HttpURLConnection)url.openConnection(this.proxy);
            this.addHeaders(headConnection);
            headConnection.setRequestMethod("HEAD");
            int statusCode = headConnection.getResponseCode();
            String reasonPhrase = headConnection.getResponseMessage();
            switch (statusCode) {
                case 200: {
                    return true;
                }
                case 404: 
                case 410: {
                    return false;
                }
                case 401: 
                case 403: 
                case 407: {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage((String)this.buildUrl(resource), (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
            }
            throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage((String)this.buildUrl(resource), (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    void setSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public LightweightHttpWagonAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(LightweightHttpWagonAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    private TransferFailedException convertHttpUrlConnectionException(IOException originalIOException, HttpURLConnection urlConnection, String url) {
        try {
            String errorResponseMessage = urlConnection.getResponseMessage();
            int errorResponseCode = urlConnection.getResponseCode();
            String message = HttpMessageUtils.formatTransferFailedMessage((String)url, (int)errorResponseCode, (String)errorResponseMessage, (ProxyInfo)this.getProxyInfo());
            return new TransferFailedException(message, (Throwable)originalIOException);
        }
        catch (IOException errorResponseMessage) {
            Matcher matcher;
            String ioMsg = originalIOException.getMessage();
            if (ioMsg != null && (matcher = IOEXCEPTION_MESSAGE_PATTERN.matcher(ioMsg)).matches()) {
                String codeStr = matcher.group(1);
                String urlStr = matcher.group(2);
                int code = -1;
                try {
                    code = Integer.parseInt(codeStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String message = HttpMessageUtils.formatTransferFailedMessage((String)urlStr, (int)code, null, (ProxyInfo)this.getProxyInfo());
                return new TransferFailedException(message, (Throwable)originalIOException);
            }
            String message = HttpMessageUtils.formatTransferFailedMessage((String)url, (int)-1, null, (ProxyInfo)this.getProxyInfo());
            return new TransferFailedException(message, (Throwable)originalIOException);
        }
    }
}

