/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.resource.Resource;

public class PutInputStream
extends FileInputStream {
    private TransferEventSupport eventSupport;
    private TransferEvent event;

    public PutInputStream(File file, Resource resource, Wagon wagon, TransferEventSupport eventSupport) throws FileNotFoundException {
        super(file);
        this.eventSupport = eventSupport;
        this.event = new TransferEvent(wagon, resource, 3, 6);
        this.event.setLocalFile(file);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retValue = super.read(b, off, len);
        if (retValue > 0) {
            this.event.setTimestamp(System.currentTimeMillis());
            this.eventSupport.fireTransferProgress(this.event, b, retValue);
        }
        return retValue;
    }
}

