/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.scm;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class ScmWagon
extends AbstractWagon {
    private volatile ScmManager scmManager;
    private String scmVersion;
    private String scmVersionType;
    private File checkoutDirectory;

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public String getScmVersion() {
        return this.scmVersion;
    }

    public void setScmVersion(String scmVersion) {
        this.scmVersion = scmVersion;
    }

    public String getScmVersionType() {
        return this.scmVersionType;
    }

    public void setScmVersionType(String scmVersionType) {
        this.scmVersionType = scmVersionType;
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(File checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public ScmProvider getScmProvider(String scmType) throws NoSuchScmProviderException {
        return this.getScmManager().getProviderByType(scmType);
    }

    public void openConnectionInternal() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            this.checkoutDirectory = this.createCheckoutDirectory();
        }
        if (this.checkoutDirectory.exists()) {
            this.removeCheckoutDirectory();
        }
        this.checkoutDirectory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCheckoutDirectory() {
        File checkoutDirectory;
        Random rand;
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        synchronized (random) {
            while ((checkoutDirectory = new File(System.getProperty("java.io.tmpdir"), "wagon-scm" + fmt.format(Math.abs(rand.nextInt())) + ".checkout")).exists()) {
            }
        }
        return checkoutDirectory;
    }

    private void removeCheckoutDirectory() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)this.checkoutDirectory);
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to cleanup checkout directory", (Throwable)e);
        }
    }

    private ScmVersion makeScmVersion() {
        if (StringUtils.isBlank((String)this.scmVersion)) {
            return null;
        }
        if (this.scmVersion.length() > 0) {
            if ("revision".equals(this.scmVersionType)) {
                return new ScmRevision(this.scmVersion);
            }
            if ("tag".equals(this.scmVersionType)) {
                return new ScmTag(this.scmVersion);
            }
            if ("branch".equals(this.scmVersionType)) {
                return new ScmBranch(this.scmVersion);
            }
        }
        return null;
    }

    private ScmRepository getScmRepository(String url) throws ScmRepositoryException, NoSuchScmProviderException {
        String username = null;
        String password = null;
        String privateKey = null;
        String passphrase = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
            privateKey = this.authenticationInfo.getPrivateKey();
            passphrase = this.authenticationInfo.getPassphrase();
        }
        ScmRepository scmRepository = this.getScmManager().makeScmRepository(url);
        ScmProviderRepository providerRepository = scmRepository.getProviderRepository();
        if (StringUtils.isNotEmpty((String)username)) {
            providerRepository.setUser(username);
        }
        if (StringUtils.isNotEmpty((String)password)) {
            providerRepository.setPassword(password);
        }
        if (providerRepository instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost providerRepo = (ScmProviderRepositoryWithHost)providerRepository;
            if (StringUtils.isNotEmpty((String)privateKey)) {
                providerRepo.setPrivateKey(privateKey);
            }
            if (StringUtils.isNotEmpty((String)passphrase)) {
                providerRepo.setPassphrase(passphrase);
            }
        }
        return scmRepository;
    }

    public void put(File source, String targetName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source is a directory: " + source);
        }
        this.putInternal(source, targetName);
    }

    private void putInternal(File source, String targetName) throws TransferFailedException {
        Resource target = new Resource(targetName);
        this.firePutInitiated(target, source);
        try {
            ScmRepository scmRepository = this.getScmRepository(this.getRepository().getUrl());
            target.setContentLength(source.length());
            target.setLastModified(source.lastModified());
            this.firePutStarted(target, source);
            String msg = "Wagon: Adding " + source.getName() + " to repository";
            ScmProvider scmProvider = this.getScmProvider(scmRepository.getProvider());
            String checkoutTargetName = source.isDirectory() ? targetName : this.getDirname(targetName);
            String relPath = this.checkOut(scmProvider, scmRepository, checkoutTargetName, target);
            File newCheckoutDirectory = new File(this.checkoutDirectory, relPath);
            File scmFile = new File(newCheckoutDirectory, source.isDirectory() ? "" : this.getFilename(targetName));
            boolean fileAlreadyInScm = scmFile.exists();
            if (!scmFile.equals(source)) {
                if (source.isDirectory()) {
                    FileUtils.copyDirectoryStructure((File)source, (File)scmFile);
                } else {
                    FileUtils.copyFile((File)source, (File)scmFile);
                }
            }
            if (!fileAlreadyInScm || scmFile.isDirectory()) {
                int addedFiles = this.addFiles(scmProvider, scmRepository, newCheckoutDirectory, source.isDirectory() ? "" : scmFile.getName());
                if (!fileAlreadyInScm && addedFiles == 0) {
                    throw new ScmException("Unable to add file to SCM: " + scmFile + "; see error messages above for more information");
                }
            }
            CheckInScmResult result = scmProvider.checkIn(scmRepository, new ScmFileSet(this.checkoutDirectory), this.makeScmVersion(), msg);
            this.checkScmResult((ScmResult)result);
        }
        catch (ScmException e) {
            this.fireTransferError(target, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(target, e, 6);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        if (source.isFile()) {
            this.postProcessListeners(target, source, 6);
        }
        this.firePutCompleted(target, source);
    }

    private String checkOut(ScmProvider scmProvider, ScmRepository scmRepository, String targetName, Resource resource) throws TransferFailedException {
        this.checkoutDirectory = this.createCheckoutDirectory();
        Stack<String> stack = new Stack<String>();
        String target = targetName;
        try {
            while (target.length() > 0 && !scmProvider.list(scmRepository, new ScmFileSet(new File("."), new File(target)), false, this.makeScmVersion()).isSuccess()) {
                stack.push(this.getFilename(target));
                target = this.getDirname(target);
            }
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException("Error listing repository: " + e.getMessage(), (Throwable)e);
        }
        try {
            String repoUrl = this.getRepository().getUrl();
            if ("svn".equals(scmProvider.getScmType())) {
                repoUrl = repoUrl + "/" + target.replace('\\', '/');
            }
            scmRepository = this.getScmRepository(repoUrl);
            CheckOutScmResult ret = scmProvider.checkOut(scmRepository, new ScmFileSet(new File(this.checkoutDirectory, "")), this.makeScmVersion(), false);
            this.checkScmResult((ScmResult)ret);
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException("Error checking out: " + e.getMessage(), (Throwable)e);
        }
        String relPath = "";
        while (!stack.isEmpty()) {
            String p = (String)stack.pop();
            File newDir = new File(this.checkoutDirectory, relPath = relPath + p + "/");
            if (!newDir.mkdirs()) {
                throw new TransferFailedException("Failed to create directory " + newDir.getAbsolutePath() + "; parent should exist: " + this.checkoutDirectory);
            }
            try {
                this.addFiles(scmProvider, scmRepository, this.checkoutDirectory, relPath);
            }
            catch (ScmException e) {
                this.fireTransferError(resource, (Exception)((Object)e), 6);
                throw new TransferFailedException("Failed to add directory " + newDir + " to working copy", (Throwable)e);
            }
        }
        return relPath;
    }

    private int addFiles(ScmProvider scmProvider, ScmRepository scmRepository, File basedir, String scmFilePath) throws ScmException {
        int addedFiles = 0;
        File scmFile = new File(basedir, scmFilePath);
        if (scmFilePath.length() != 0) {
            AddScmResult result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)));
            if (!result.isSuccess()) {
                result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)));
            }
            addedFiles = result.getAddedFiles().size();
        }
        String reservedScmFile = scmProvider.getScmSpecificFilename();
        if (scmFile.isDirectory()) {
            for (File file : scmFile.listFiles()) {
                if (reservedScmFile == null || reservedScmFile.equals(file.getName())) continue;
                addedFiles += this.addFiles(scmProvider, scmRepository, basedir, (scmFilePath.length() == 0 ? "" : scmFilePath + "/") + file.getName());
            }
        }
        return addedFiles;
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Source is not a directory: " + sourceDirectory);
        }
        this.putInternal(sourceDirectory, destinationDirectory);
    }

    private void checkScmResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            throw new ScmException("Unable to commit file. " + result.getProviderMessage() + " " + (result.getCommandOutput() == null ? "" : result.getCommandOutput()));
        }
    }

    public void closeConnection() throws ConnectionException {
        this.removeCheckoutDirectory();
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("Not currently supported: getIfNewer");
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        String url = this.getRepository().getUrl() + "/" + resourceName;
        url = url.substring(0, url.lastIndexOf(47));
        try {
            ScmRepository scmRepository = this.getScmRepository(url);
            this.fireGetStarted(resource, destination);
            File scmFile = new File(this.checkoutDirectory, resourceName);
            File basedir = scmFile.getParentFile();
            ScmProvider scmProvider = this.getScmProvider(scmRepository.getProvider());
            String reservedScmFile = scmProvider.getScmSpecificFilename();
            if (reservedScmFile != null && new File(basedir, reservedScmFile).exists()) {
                scmProvider.update(scmRepository, new ScmFileSet(basedir), this.makeScmVersion());
            } else {
                basedir.mkdirs();
                scmProvider.checkOut(scmRepository, new ScmFileSet(basedir), this.makeScmVersion());
            }
            if (!scmFile.exists()) {
                throw new ResourceDoesNotExistException("Unable to find resource " + destination + " after checkout");
            }
            if (!scmFile.equals(destination)) {
                FileUtils.copyFile((File)scmFile, (File)destination);
            }
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException("Error getting file from SCM", (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException("Error getting file from SCM", (Throwable)e);
        }
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    public List<String> getFileList(String resourcePath) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            ScmRepository repository = this.getScmRepository(this.getRepository().getUrl());
            ScmProvider provider = this.getScmProvider(repository.getProvider());
            ListScmResult result = provider.list(repository, new ScmFileSet(new File("."), new File(resourcePath)), false, this.makeScmVersion());
            if (!result.isSuccess()) {
                throw new ResourceDoesNotExistException(result.getProviderMessage());
            }
            ArrayList<String> files = new ArrayList<String>();
            for (ScmFile f : result.getFiles()) {
                files.add(f.getPath());
            }
            return files;
        }
        catch (ScmException e) {
            throw new TransferFailedException("Error getting filelist from SCM", (Throwable)e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            this.getFileList(resourceName);
            return true;
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
    }

    private String getFilename(String filename) {
        String fname = StringUtils.replace((String)filename, (String)"/", (String)File.separator);
        return FileUtils.filename((String)fname);
    }

    private String getDirname(String filename) {
        String fname = StringUtils.replace((String)filename, (String)"/", (String)File.separator);
        return FileUtils.dirname((String)fname);
    }
}

