/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.scm;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class ScmWagon
extends AbstractWagon {
    private volatile ScmManager scmManager;
    private String scmVersion;
    private String scmVersionType;
    private String partCOSubdir = "";
    private boolean haveRecursiveCO;
    private File checkoutDirectory;

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public String getScmVersion() {
        return this.scmVersion;
    }

    public void setScmVersion(String scmVersion) {
        this.scmVersion = scmVersion;
    }

    public String getScmVersionType() {
        return this.scmVersionType;
    }

    public void setScmVersionType(String scmVersionType) {
        this.scmVersionType = scmVersionType;
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(File checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public ScmProvider getScmProvider(String scmType) throws NoSuchScmProviderException {
        return this.getScmManager().getProviderByType(scmType);
    }

    public void openConnectionInternal() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            this.checkoutDirectory = this.createCheckoutDirectory();
        }
        if (this.checkoutDirectory.exists()) {
            this.removeCheckoutDirectory();
        }
        this.checkoutDirectory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCheckoutDirectory() {
        File checkoutDirectory;
        Random rand;
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        synchronized (random) {
            while ((checkoutDirectory = new File(System.getProperty("java.io.tmpdir"), "wagon-scm" + fmt.format(Math.abs(rand.nextInt())) + ".checkout")).exists()) {
            }
        }
        return checkoutDirectory;
    }

    private void removeCheckoutDirectory() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            return;
        }
        try {
            this.deleteCheckoutDirectory();
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to cleanup checkout directory", (Throwable)e);
        }
    }

    private ScmVersion makeScmVersion() {
        if (StringUtils.isBlank((String)this.scmVersion)) {
            return null;
        }
        if (this.scmVersion.length() > 0) {
            if ("revision".equals(this.scmVersionType)) {
                return new ScmRevision(this.scmVersion);
            }
            if ("tag".equals(this.scmVersionType)) {
                return new ScmTag(this.scmVersion);
            }
            if ("branch".equals(this.scmVersionType)) {
                return new ScmBranch(this.scmVersion);
            }
        }
        return null;
    }

    private ScmRepository getScmRepository(String url) throws ScmRepositoryException, NoSuchScmProviderException {
        String username = null;
        String password = null;
        String privateKey = null;
        String passphrase = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
            privateKey = this.authenticationInfo.getPrivateKey();
            passphrase = this.authenticationInfo.getPassphrase();
        }
        ScmRepository scmRepository = this.getScmManager().makeScmRepository(url);
        ScmProviderRepository providerRepository = scmRepository.getProviderRepository();
        if (StringUtils.isNotEmpty((String)username)) {
            providerRepository.setUser(username);
        }
        if (StringUtils.isNotEmpty((String)password)) {
            providerRepository.setPassword(password);
        }
        if (providerRepository instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost providerRepo = (ScmProviderRepositoryWithHost)providerRepository;
            if (StringUtils.isNotEmpty((String)privateKey)) {
                providerRepo.setPrivateKey(privateKey);
            }
            if (StringUtils.isNotEmpty((String)passphrase)) {
                providerRepo.setPassphrase(passphrase);
            }
        }
        return scmRepository;
    }

    public void put(File source, String targetName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source is a directory: " + source);
        }
        this.putInternal(source, targetName);
    }

    private void putInternal(File source, String targetName) throws TransferFailedException {
        Resource target = new Resource(targetName);
        this.firePutInitiated(target, source);
        try {
            ScmRepository scmRepository = this.getScmRepository(this.getRepository().getUrl());
            target.setContentLength(source.length());
            target.setLastModified(source.lastModified());
            this.firePutStarted(target, source);
            String msg = "Wagon: Adding " + source.getName() + " to repository";
            ScmProvider scmProvider = this.getScmProvider(scmRepository.getProvider());
            boolean isDirectory = source.isDirectory();
            String checkoutTargetName = isDirectory ? targetName : this.getDirname(targetName);
            boolean recursive = false;
            if (isDirectory) {
                for (File f : source.listFiles()) {
                    if (!f.isDirectory()) continue;
                    recursive = true;
                    break;
                }
            }
            String relPath = this.ensureDirs(scmProvider, scmRepository, checkoutTargetName, target, recursive);
            File newCheckoutDirectory = new File(this.checkoutDirectory, relPath);
            File scmFile = new File(newCheckoutDirectory, isDirectory ? "" : FileUtils.removePath((String)targetName, (char)'/'));
            boolean fileAlreadyInScm = scmFile.exists();
            if (!scmFile.equals(source)) {
                if (isDirectory) {
                    FileUtils.copyDirectoryStructure((File)source, (File)scmFile);
                } else {
                    FileUtils.copyFile((File)source, (File)scmFile);
                }
            }
            if (!fileAlreadyInScm || scmFile.isDirectory()) {
                int addedFiles = this.addFiles(scmProvider, scmRepository, newCheckoutDirectory, isDirectory ? "" : scmFile.getName());
                if (!fileAlreadyInScm && addedFiles == 0) {
                    throw new ScmException("Unable to add file to SCM: " + scmFile + "; see error messages above for more information");
                }
            }
            CheckInScmResult result = scmProvider.checkIn(scmRepository, new ScmFileSet(this.checkoutDirectory), this.makeScmVersion(), msg);
            this.checkScmResult((ScmResult)result);
        }
        catch (ScmException e) {
            this.fireTransferError(target, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(target, e, 6);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        if (source.isFile()) {
            this.postProcessListeners(target, source, 6);
        }
        this.firePutCompleted(target, source);
    }

    private String ensureDirs(ScmProvider scmProvider, ScmRepository scmRepository, String targetName, Resource resource, boolean recursiveArg) throws TransferFailedException, IOException {
        Object res;
        if (this.checkoutDirectory == null) {
            this.checkoutDirectory = this.createCheckoutDirectory();
        }
        String target = targetName;
        boolean recursive = recursiveArg;
        while (true) {
            try {
                res = this.tryPartialCheckout(target, recursive);
                if (!res.isSuccess()) {
                    throw new ScmException("command failed: " + res.getCommandOutput().trim());
                }
            }
            catch (ScmException e) {
                recursive = false;
                if (this.partCOSubdir.length() == 0) {
                    this.fireTransferError(resource, (Exception)((Object)e), 5);
                    throw new TransferFailedException("Error checking out: " + e.getMessage(), (Throwable)e);
                }
                target = this.getDirname(target);
                continue;
            }
            break;
        }
        res = this.partCOSubdir.length() >= targetName.length() ? "" : targetName.substring(this.partCOSubdir.length()) + '/';
        ArrayList<File> createdDirs = new ArrayList<File>();
        File deepDir = new File(this.checkoutDirectory, (String)res);
        boolean added = false;
        try {
            ScmWagon.mkdirsThrow(deepDir, createdDirs);
            if (createdDirs.size() != 0) {
                File topNewDir = createdDirs.get(0);
                String relTopNewDir = topNewDir.getPath().substring(this.checkoutDirectory.getPath().length() + 1).replace('\\', '/');
                this.addFiles(scmProvider, scmRepository, this.checkoutDirectory, relTopNewDir);
                added = true;
            }
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Failed to add directory " + createdDirs.get(0) + " to working copy", (Throwable)e);
        }
        finally {
            if (!added && createdDirs.size() != 0) {
                FileUtils.deleteDirectory((File)createdDirs.get(0));
            }
        }
        return res;
    }

    private static void mkdirsThrow(File f, List<File> createdDirs) throws IOException {
        if (!f.isDirectory()) {
            File parent = f.getParentFile();
            ScmWagon.mkdirsThrow(parent, createdDirs);
            if (!f.mkdir()) {
                throw new IOException("Failed to create directory " + f.getAbsolutePath());
            }
            createdDirs.add(f);
        }
    }

    private int addFiles(ScmProvider scmProvider, ScmRepository scmRepository, File basedir, String scmFilePath) throws ScmException {
        int addedFiles = 0;
        File scmFile = new File(basedir, scmFilePath);
        if (scmFilePath.length() != 0) {
            AddScmResult result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)), this.mkBinaryFlag());
            if (!result.isSuccess()) {
                result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)), this.mkBinaryFlag());
            }
            addedFiles = result.getAddedFiles().size();
        }
        String reservedScmFile = scmProvider.getScmSpecificFilename();
        if (scmFile.isDirectory()) {
            for (File file : scmFile.listFiles()) {
                if (reservedScmFile == null || reservedScmFile.equals(file.getName())) continue;
                addedFiles += this.addFiles(scmProvider, scmRepository, basedir, (scmFilePath.length() == 0 ? "" : scmFilePath + "/") + file.getName());
            }
        }
        return addedFiles;
    }

    private CheckOutScmResult checkOut(ScmProvider scmProvider, ScmRepository scmRepository, ScmFileSet fileSet, boolean recursive) throws ScmException {
        ScmVersion ver = this.makeScmVersion();
        CommandParameters parameters = this.mkBinaryFlag();
        parameters.setScmVersion(CommandParameter.SCM_VERSION, ver);
        parameters.setString(CommandParameter.RECURSIVE, Boolean.toString(recursive));
        parameters.setString(CommandParameter.SHALLOW, Boolean.toString(true));
        return scmProvider.checkOut(scmRepository, fileSet, ver, parameters);
    }

    private CommandParameters mkBinaryFlag() throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.BINARY, Boolean.toString(true));
        return parameters;
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    private boolean supportsPartialCheckout(ScmProvider scmProvider) {
        String scmType = scmProvider.getScmType();
        return "svn".equals(scmType) || "cvs".equals(scmType);
    }

    private boolean isAlwaysRecursive(ScmProvider scmProvider) {
        String scmType = scmProvider.getScmType();
        return "git".equals(scmType) || "cvs".equals(scmType);
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Source is not a directory: " + sourceDirectory);
        }
        this.putInternal(sourceDirectory, destinationDirectory);
    }

    private void checkScmResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            throw new ScmException("Unable to commit file. " + result.getProviderMessage() + " " + (result.getCommandOutput() == null ? "" : result.getCommandOutput()));
        }
    }

    public void closeConnection() throws ConnectionException {
        this.removeCheckoutDirectory();
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("Not currently supported: getIfNewer");
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        this.fireGetStarted(resource, destination);
        try {
            String subdir = this.getDirname(resourceName);
            ScmResult res = this.tryPartialCheckout(subdir, false);
            if (!res.isSuccess() && (this.partCOSubdir.length() == 0 || res instanceof UpdateScmResult)) {
                throw new ScmException("command failed: " + res.getCommandOutput().trim());
            }
            File scmFile = new File(this.checkoutDirectory, resourceName = resourceName.substring(this.partCOSubdir.length()));
            if (!scmFile.exists()) {
                throw new ResourceDoesNotExistException("Unable to find resource " + destination + " after checkout");
            }
            if (!scmFile.equals(destination)) {
                FileUtils.copyFile((File)scmFile, (File)destination);
            }
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException("Error getting file from SCM", (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException("Error getting file from SCM", (Throwable)e);
        }
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    private ScmResult tryPartialCheckout(String subdir, boolean recursiveArg) throws ScmException, IOException {
        UpdateScmResult res;
        String url = this.getRepository().getUrl();
        String desiredPartCOSubdir = "";
        ScmRepository scmRepository = this.getScmRepository(url);
        ScmProvider scmProvider = this.getScmProvider(scmRepository.getProvider());
        if (subdir.length() != 0 && this.supportsPartialCheckout(scmProvider)) {
            url = url + (url.endsWith("/") ? "" : "/") + subdir;
            desiredPartCOSubdir = subdir + "/";
            scmRepository = this.getScmRepository(url);
        }
        boolean recursive = recursiveArg | this.isAlwaysRecursive(scmProvider);
        if (!desiredPartCOSubdir.equals(this.partCOSubdir)) {
            this.deleteCheckoutDirectory();
            this.partCOSubdir = desiredPartCOSubdir;
        }
        if (recursive && !this.haveRecursiveCO) {
            this.deleteCheckoutDirectory();
        }
        if (this.checkoutDirExists(scmProvider)) {
            res = scmProvider.update(scmRepository, new ScmFileSet(this.checkoutDirectory), this.makeScmVersion());
        } else {
            res = this.checkOut(scmProvider, scmRepository, new ScmFileSet(this.checkoutDirectory), recursive);
            this.haveRecursiveCO = recursive && res.isSuccess();
        }
        return res;
    }

    private void deleteCheckoutDirectory() throws IOException {
        this.haveRecursiveCO = false;
        FileUtils.deleteDirectory((File)this.checkoutDirectory);
    }

    private boolean checkoutDirExists(ScmProvider scmProvider) {
        String reservedScmFile = scmProvider.getScmSpecificFilename();
        File pathToCheck = reservedScmFile == null ? this.checkoutDirectory : new File(this.checkoutDirectory, reservedScmFile);
        return pathToCheck.exists();
    }

    public List<String> getFileList(String resourcePath) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            ScmRepository repository = this.getScmRepository(this.getRepository().getUrl());
            ScmProvider provider = this.getScmProvider(repository.getProvider());
            ListScmResult result = provider.list(repository, new ScmFileSet(new File("."), new File(resourcePath)), false, this.makeScmVersion());
            if (!result.isSuccess()) {
                throw new ResourceDoesNotExistException(result.getProviderMessage());
            }
            ArrayList<String> files = new ArrayList<String>();
            for (ScmFile f : result.getFiles()) {
                files.add(f.getPath());
            }
            return files;
        }
        catch (ScmException e) {
            throw new TransferFailedException("Error getting filelist from SCM", (Throwable)e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            this.getFileList(resourceName);
            return true;
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
    }

    private String getDirname(String resourceName) {
        return FileUtils.getPath((String)resourceName, (char)'/');
    }
}

