/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.webdav.CorrectedWebdavResource;
import org.apache.maven.wagon.providers.webdav.PutInputStream;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.webdav.lib.WebdavResource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class WebDavWagon
extends AbstractWagon {
    private static final TimeZone TIMESTAMP_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static String wagonVersion;
    private DateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
    private CorrectedWebdavResource webdavResource;

    public WebDavWagon() {
        this.dateFormat.setTimeZone(TIMESTAMP_TIME_ZONE);
        if (wagonVersion == null) {
            URL pomUrl = ((Object)((Object)this)).getClass().getResource("/META-INF/maven/org.apache.maven.wagon/wagon-webdav/pom.properties");
            if (pomUrl == null) {
                wagonVersion = "";
            } else {
                Properties props = new Properties();
                try {
                    props.load(pomUrl.openStream());
                    wagonVersion = props.getProperty("version");
                    System.out.println("WAGON_VERSION: " + wagonVersion);
                }
                catch (IOException e) {
                    wagonVersion = "";
                }
            }
        }
    }

    public void openConnection() throws AuthenticationException, ConnectionException {
        String url = this.getURL(this.repository);
        this.repository.setUrl(url);
        HttpURL httpURL = null;
        try {
            httpURL = this.urlToHttpURL(url);
            if (this.authenticationInfo != null) {
                String userName = this.authenticationInfo.getUserName();
                String password = this.authenticationInfo.getPassword();
                if (userName != null && password != null) {
                    httpURL.setUserinfo(userName, password);
                }
            }
            WebdavResource.setDefaultAction((int)1);
            this.webdavResource = new CorrectedWebdavResource(httpURL);
        }
        catch (HttpException he) {
            throw new ConnectionException("Connection Exception: " + url + " " + he.getReasonCode() + " " + HttpStatus.getStatusText((int)he.getReasonCode()), (Throwable)he);
        }
        catch (URIException urie) {
            throw new ConnectionException("Connection Exception: " + urie.getReason(), (Throwable)urie);
        }
        catch (IOException ioe) {
            throw new ConnectionException("Connection Exception: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void closeConnection() throws ConnectionException {
        try {
            if (this.webdavResource != null) {
                this.webdavResource.close();
            }
        }
        catch (IOException ioe) {
            throw new ConnectionException("Connection Exception: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            this.webdavResource = null;
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource;
        String dest;
        block17: {
            Repository repository = this.getRepository();
            String basedir = repository.getBasedir();
            resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
            String dir = PathUtils.dirname((String)resourceName);
            dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
            dest = repository.getUrl();
            resource = new Resource(resourceName);
            dest = dest.endsWith("/") ? dest + resource.getName() : dest + "/" + resource.getName();
            this.firePutInitiated(resource, source);
            String oldpath = this.webdavResource.getPath();
            String relpath = AbstractWagon.getPath((String)basedir, (String)dir);
            try {
                String cdpath = this.checkUri(relpath + "/");
                this.webdavResource.setPath(cdpath);
                if (this.webdavResource.exists() && !this.webdavResource.isCollection()) {
                    throw new TransferFailedException("Destination path exists and is not a WebDAV collection (directory): " + cdpath);
                }
                this.webdavResource.setPath(oldpath);
                if (this.webdavResource.exists()) break block17;
                try {
                    String[] dirs = relpath.split("/");
                    String createDir = "";
                    for (int count = 1; count < dirs.length; ++count) {
                        createDir = createDir + "/" + dirs[count];
                        this.webdavResource.mkcolMethod(createDir);
                    }
                    this.webdavResource.setPath(oldpath);
                }
                catch (IOException ioe) {
                    throw new TransferFailedException("Failed to create destination WebDAV collection (directory): " + relpath, (Throwable)ioe);
                }
            }
            catch (IOException e) {
                throw new TransferFailedException("Failed to create destination WebDAV collection (directory): " + relpath, (Throwable)e);
            }
        }
        try {
            this.firePutStarted(resource, source);
            PutInputStream is = new PutInputStream(source, resource, (Wagon)this, this.getTransferEventSupport());
            boolean success = this.webdavResource.putMethod(dest, is, (int)source.length());
            int statusCode = this.webdavResource.getStatusCode();
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 201: {
                    break;
                }
                case 403: {
                    throw new AuthorizationException("Access denided to: " + dest);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + dest + " does not exist");
                }
                case 411: {
                    throw new ResourceDoesNotExistException("Transfer failed, server requires Content-Length.");
                }
                default: {
                    if (!success) {
                        throw new TransferFailedException("Failed to transfer file: " + dest + ". Return code is: " + statusCode + " " + HttpStatus.getStatusText((int)statusCode));
                    }
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException("Specified source file does not exist: " + source, (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            String msg = "PUT request for: " + resource + " to " + source.getName() + " failed";
            throw new TransferFailedException(msg, (Throwable)e);
        }
        this.firePutCompleted(resource, source);
    }

    private HttpURL urlToHttpURL(String url) throws URIException {
        if (url.startsWith("https")) {
            return new HttpsURL(url);
        }
        return new HttpURL(url);
    }

    private String checkUri(String uri) throws IOException {
        if (this.webdavResource == null) {
            throw new IOException("Not connected yet.");
        }
        if (uri == null) {
            uri = this.webdavResource.getPath();
        }
        return FileUtils.normalize((String)uri);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.get(resourceName, destination, 0L);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.get(resourceName, destination, timestamp);
    }

    /*
     * Exception decompiling
     */
    public boolean get(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getURL(Repository repository) {
        String s;
        String url = repository.getUrl();
        if (url.startsWith(s = "dav:")) {
            return url.substring(s.length());
        }
        return url;
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String createPath = this.repository.getBasedir() + "/" + destinationDirectory;
        try {
            this.webdavResource.mkcolMethod(createPath);
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to create remote directory: " + createPath + " : " + e.getMessage(), (Throwable)e);
        }
        try {
            this.webdavResource.setPath(this.repository.getBasedir());
        }
        catch (IOException e) {
            throw new TransferFailedException("An error occurred while preparing to copy to remote repository: " + e.getMessage(), (Throwable)e);
        }
        File[] listFiles = sourceDirectory.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory()) {
                this.putDirectory(listFiles[i], destinationDirectory + "/" + listFiles[i].getName());
                continue;
            }
            String target = createPath + "/" + listFiles[i].getName();
            try {
                this.webdavResource.putMethod(target, listFiles[i]);
                continue;
            }
            catch (IOException e) {
                throw new TransferFailedException("Failed to upload to remote repository: " + target + " : " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

