/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.api;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

@Vetoed
public class PersistenceUnitInfoBuilder {
    private String unitName;
    private String providerClass;
    private DataSource dataSource;
    private DataSource jtaDataSource;
    private List<String> mappingFiles = Collections.emptyList();
    private List<URL> jarFiles = Collections.emptyList();
    private URL rootUrl;
    private List<String> managedClasses = new ArrayList<String>();
    private boolean excludeUnlistedClasses;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;
    private Properties properties = new Properties();
    private String version = "2.0";
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public PersistenceUnitInfoBuilder setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public PersistenceUnitInfoBuilder setUnitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public PersistenceUnitInfoBuilder setProviderClass(String providerClass) {
        this.providerClass = providerClass;
        return this;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public PersistenceUnitInfoBuilder setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public PersistenceUnitInfoBuilder setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public List<String> getMappingFiles() {
        return this.mappingFiles;
    }

    public PersistenceUnitInfoBuilder setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
        return this;
    }

    public List<URL> getJarFiles() {
        return this.jarFiles;
    }

    public PersistenceUnitInfoBuilder setJarFiles(List<URL> jarFiles) {
        this.jarFiles = jarFiles;
        return this;
    }

    public URL getRootUrl() {
        return this.rootUrl;
    }

    public PersistenceUnitInfoBuilder setRootUrl(URL rootUrl) {
        this.rootUrl = rootUrl;
        return this;
    }

    public List<String> getManagedClasses() {
        return this.managedClasses;
    }

    public PersistenceUnitInfoBuilder addManagedClazz(Class<?> clazz) {
        this.managedClasses.add(clazz.getName());
        return this;
    }

    public PersistenceUnitInfoBuilder setManagedClassNames(List<String> managedClasses) {
        this.managedClasses = managedClasses;
        return this;
    }

    public PersistenceUnitInfoBuilder setManagedClasses(List<Class<?>> managedClasses) {
        this.managedClasses = managedClasses.stream().map(Class::getName).collect(Collectors.toList());
        return this;
    }

    public boolean isExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public PersistenceUnitInfoBuilder setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
        return this;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public PersistenceUnitInfoBuilder setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
        return this;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public PersistenceUnitInfoBuilder setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public PersistenceUnitInfoBuilder addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        return this;
    }

    public PersistenceUnitInfoBuilder setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PersistenceUnitInfoBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public PersistenceUnitInfoBuilder setLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    public PersistenceUnitInfo toInfo() {
        if (this.providerClass == null) {
            this.providerClass = ServiceLoader.load(PersistenceProvider.class).iterator().next().getClass().getName();
        }
        Objects.requireNonNull(this.dataSource, "datasource not provided");
        return new PersistenceUnitInfo(){

            public String getPersistenceUnitName() {
                return PersistenceUnitInfoBuilder.this.unitName;
            }

            public String getPersistenceProviderClassName() {
                return PersistenceUnitInfoBuilder.this.providerClass;
            }

            public PersistenceUnitTransactionType getTransactionType() {
                return PersistenceUnitInfoBuilder.this.transactionType;
            }

            public DataSource getJtaDataSource() {
                return PersistenceUnitInfoBuilder.this.jtaDataSource;
            }

            public DataSource getNonJtaDataSource() {
                return PersistenceUnitInfoBuilder.this.dataSource;
            }

            public List<String> getMappingFileNames() {
                return PersistenceUnitInfoBuilder.this.mappingFiles;
            }

            public List<URL> getJarFileUrls() {
                return PersistenceUnitInfoBuilder.this.jarFiles;
            }

            public URL getPersistenceUnitRootUrl() {
                return PersistenceUnitInfoBuilder.this.rootUrl;
            }

            public List<String> getManagedClassNames() {
                return PersistenceUnitInfoBuilder.this.managedClasses;
            }

            public boolean excludeUnlistedClasses() {
                return PersistenceUnitInfoBuilder.this.excludeUnlistedClasses;
            }

            public SharedCacheMode getSharedCacheMode() {
                return PersistenceUnitInfoBuilder.this.sharedCacheMode;
            }

            public ValidationMode getValidationMode() {
                return PersistenceUnitInfoBuilder.this.validationMode;
            }

            public Properties getProperties() {
                return PersistenceUnitInfoBuilder.this.properties;
            }

            public String getPersistenceXMLSchemaVersion() {
                return PersistenceUnitInfoBuilder.this.version;
            }

            public ClassLoader getClassLoader() {
                return PersistenceUnitInfoBuilder.this.loader;
            }

            public void addTransformer(ClassTransformer transformer) {
            }

            public ClassLoader getNewTempClassLoader() {
                return new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            }
        };
    }
}

