/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.jpa.api.Jpa;
import org.apache.meecrowave.jpa.api.PersistenceUnitInfoBuilder;
import org.apache.meecrowave.jpa.api.Unit;
import org.apache.meecrowave.jpa.internal.AutoJpaAnnotationType;
import org.apache.meecrowave.jpa.internal.EntityManagerBean;
import org.apache.meecrowave.jpa.internal.EntityManagerContext;
import org.apache.meecrowave.jpa.internal.JpaNoTransactionInterceptor;
import org.apache.meecrowave.jpa.internal.JpaTransactionInterceptor;

public class JpaExtension
implements Extension {
    private final EntityManagerContext entityManagerContext = new EntityManagerContext();
    private final List<String> jpaClasses = new ArrayList<String>();
    private final Map<UnitKey, EntityManagerBean> entityManagerBeans = new HashMap<UnitKey, EntityManagerBean>();
    private final Collection<Bean<?>> unitBuilders = new ArrayList(2);

    void addInternals(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        Stream.of(JpaTransactionInterceptor.class, JpaNoTransactionInterceptor.class).forEach(interceptor -> bbd.addAnnotatedType(bm.createAnnotatedType(interceptor)));
    }

    <T> void addJpaToEmConsumers(@Observes @WithAnnotations(value={Unit.class}) ProcessAnnotatedType<T> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(Jpa.class)) {
            return;
        }
        pat.setAnnotatedType(new AutoJpaAnnotationType(pat.getAnnotatedType()));
    }

    void collectEntityManagerInjections(@Observes ProcessBean<?> bean) {
        Map<UnitKey, EntityManagerBean> beans = bean.getBean().getInjectionPoints().stream().filter(i -> i.getAnnotated().isAnnotationPresent(Unit.class)).map(i -> (Unit)i.getAnnotated().getAnnotation(Unit.class)).collect(Collectors.toMap(u -> new UnitKey(u.name(), u.synchronization()), unit -> new EntityManagerBean(this.entityManagerContext, unit.name(), unit.synchronization())));
        this.entityManagerBeans.putAll(beans);
    }

    void collectEntityManagers(@Observes ProcessBean<?> bean) {
        if (bean.getBean().getTypes().contains(PersistenceUnitInfoBuilder.class)) {
            this.unitBuilders.add(bean.getBean());
        }
    }

    void collectEntities(@Observes @WithAnnotations(value={Entity.class, MappedSuperclass.class, Embeddable.class}) ProcessAnnotatedType<?> jpa) {
        this.jpaClasses.add(jpa.getAnnotatedType().getJavaClass().getName());
    }

    void addBeans(@Observes AfterBeanDiscovery afb, BeanManager bm) {
        afb.addContext((Context)this.entityManagerContext);
        this.entityManagerBeans.forEach((n, b) -> afb.addBean((Bean)b));
    }

    void initBeans(@Observes AfterDeploymentValidation adv, BeanManager bm) {
        if (this.entityManagerBeans.isEmpty()) {
            return;
        }
        ServletContext sc = (ServletContext)ServletContext.class.cast(bm.getReference(bm.resolve(bm.getBeans(ServletContext.class, new Annotation[0])), ServletContext.class, bm.createCreationalContext(null)));
        Meecrowave.Builder config = (Meecrowave.Builder)Meecrowave.Builder.class.cast(sc.getAttribute("meecrowave.configuration"));
        HashMap props = new HashMap();
        if (config != null) {
            Optional.ofNullable(config.getProperties()).ifPresent(p -> p.stringPropertyNames().stream().filter(k -> k.startsWith("jpa.property.")).forEach(k -> props.put(k.substring("jpa.property.".length()), p.getProperty((String)k))));
        }
        Map infoIndex = this.unitBuilders.stream().map(bean -> {
            CreationalContext cc = bm.createCreationalContext(null);
            try {
                Bean resolvedBean = bm.resolve(bm.getBeans(PersistenceUnitInfoBuilder.class, bean.getQualifiers().toArray(new Annotation[bean.getQualifiers().size()])));
                PersistenceUnitInfoBuilder builder = (PersistenceUnitInfoBuilder)PersistenceUnitInfoBuilder.class.cast(bm.getReference(resolvedBean, PersistenceUnitInfoBuilder.class, cc));
                if (builder.getManagedClasses().isEmpty()) {
                    builder.setManagedClassNames(this.jpaClasses).setExcludeUnlistedClasses(true);
                }
                props.forEach(builder::addProperty);
                PersistenceUnitInfo persistenceUnitInfo = builder.toInfo();
                return persistenceUnitInfo;
            }
            finally {
                cc.release();
            }
        }).collect(Collectors.toMap(PersistenceUnitInfo::getPersistenceUnitName, Function.identity()));
        this.entityManagerBeans.forEach((k, e) -> {
            PersistenceUnitInfo info = (PersistenceUnitInfo)infoIndex.get(((UnitKey)k).unitName);
            if (info == null) {
                info = this.tryCreateDefaultPersistenceUnit(((UnitKey)k).unitName, bm, props);
            }
            if (info == null) {
                adv.addDeploymentProblem((Throwable)new IllegalArgumentException("Didn't find any PersistenceUnitInfoBuilder for " + k));
            } else {
                e.init(info, bm);
            }
        });
    }

    private PersistenceUnitInfo tryCreateDefaultPersistenceUnit(String unitName, BeanManager bm, Map<String, String> props) {
        Set beans = bm.getBeans(DataSource.class, new Annotation[0]);
        Bean bean = bm.resolve(beans);
        if (bean == null || !bm.isNormalScope(bean.getScope())) {
            return null;
        }
        DataSource ds = (DataSource)DataSource.class.cast(bm.getReference(bean, DataSource.class, bm.createCreationalContext(null)));
        PersistenceUnitInfoBuilder builder = new PersistenceUnitInfoBuilder().setManagedClassNames(this.jpaClasses).setExcludeUnlistedClasses(true).setUnitName(unitName).setDataSource(ds);
        props.forEach(builder::addProperty);
        return builder.toInfo();
    }

    public EntityManagerContext getEntityManagerContext() {
        return this.entityManagerContext;
    }

    private static class UnitKey {
        private final String unitName;
        private final SynchronizationType synchronizationType;
        private final int hash;

        private UnitKey(String unitName, SynchronizationType synchronizationType) {
            this.unitName = unitName;
            this.synchronizationType = synchronizationType;
            this.hash = 31 * unitName.hashCode() + synchronizationType.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnitKey unitKey = (UnitKey)UnitKey.class.cast(o);
            return this.unitName.equals(unitKey.unitName) && this.synchronizationType == unitKey.synchronizationType;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "UnitKey{unitName='" + this.unitName + '\'' + ", synchronizationType=" + this.synchronizationType + '}';
        }
    }
}

