/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.internal;

import java.io.Serializable;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.meecrowave.jpa.internal.EntityManagerContext;
import org.apache.meecrowave.jpa.internal.JpaExtension;

public abstract class JpaInterceptorBase
implements Serializable {
    @Inject
    private JpaExtension extension;

    @AroundInvoke
    public Object inTransaction(InvocationContext context) throws Exception {
        EntityManagerContext entityManagerContext = this.extension.getEntityManagerContext();
        boolean owner = entityManagerContext.enter(this.isTransactional());
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            entityManagerContext.failed();
            throw e;
        }
        finally {
            entityManagerContext.exit(owner);
        }
    }

    protected abstract boolean isTransactional();
}

