/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.testing;

import java.util.stream.Stream;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.testing.ConfigurationInject;

public final class Injector {
    private Injector() {
    }

    public static CreationalContext<?> inject(Object testInstance) {
        if (testInstance == null) {
            return null;
        }
        BeanManager bm = CDI.current().getBeanManager();
        AnnotatedType annotatedType = bm.createAnnotatedType(testInstance.getClass());
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        CreationalContext creationalContext = bm.createCreationalContext(null);
        injectionTarget.inject(testInstance, creationalContext);
        return creationalContext;
    }

    public static void injectConfig(Meecrowave.Builder config, Object test) {
        if (test == null) {
            return;
        }
        Class<?> aClass = test.getClass();
        Stream.of(aClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ConfigurationInject.class)).forEach(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            try {
                f.set(test, config);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

