/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.arff;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.arff.ArffDataSet;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArffDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ArffDataContext.class);
    private static final String SECTION_ANNOTATION_RELATION = "@relation";
    private static final String SECTION_ANNOTATION_ATTRIBUTE = "@attribute";
    private static final String SECTION_ANNOTATION_DATA = "@data";
    private static final Charset CHARSET = FileHelper.UTF_8_CHARSET;
    private static final Pattern ATTRIBUTE_DEF_W_DATATYPE_PARAM = Pattern.compile("\\'?(.+)\\'?\\s+([a-zA-Z]+)\\s+\\'(.+)\\'");
    private final Splitter whitespaceSplitter = Splitter.on((CharMatcher)CharMatcher.whitespace()).trimResults().omitEmptyStrings();
    private final Resource resource;

    public ArffDataContext(Resource resource) {
        this.resource = resource;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        MutableTable table = new MutableTable(this.getMainSchemaName(), TableType.TABLE, (Schema)schema);
        schema.addTable((Table)table);
        try (BufferedReader reader = this.createReader();){
            boolean inHeader = true;
            String line = reader.readLine();
            while (inHeader && line != null) {
                if (!ArffDataContext.isIgnoreLine(line)) {
                    List split = this.whitespaceSplitter.limit(2).splitToList((CharSequence)line);
                    switch (((String)split.get(0)).toLowerCase()) {
                        case "@relation": {
                            String tableName = this.trimString((String)split.get(1));
                            table.setName(tableName);
                            break;
                        }
                        case "@attribute": {
                            ColumnType columnType;
                            String attributeParam;
                            String attributeType;
                            String attributeName;
                            String attributeDef = ((String)split.get(1)).trim();
                            int indexOfCurly = attributeDef.indexOf(123);
                            if (indexOfCurly != -1) {
                                attributeName = this.trimString(attributeDef.substring(0, indexOfCurly).trim());
                                attributeType = attributeDef.substring(indexOfCurly);
                                attributeParam = null;
                            } else {
                                Object matcher = ATTRIBUTE_DEF_W_DATATYPE_PARAM.matcher(attributeDef);
                                if (((Matcher)matcher).find()) {
                                    attributeName = ((Matcher)matcher).group(1);
                                    attributeType = ((Matcher)matcher).group(2);
                                    attributeParam = ((Matcher)matcher).group(3);
                                } else {
                                    List attributeDefSplit = this.whitespaceSplitter.splitToList((CharSequence)attributeDef);
                                    if (attributeDefSplit.size() != 2) {
                                        throw new IllegalStateException(this.resource.getName() + ": Unable to parse attribute line: " + line);
                                    }
                                    attributeName = this.trimString((String)attributeDefSplit.get(0));
                                    attributeType = (String)attributeDefSplit.get(1);
                                    attributeParam = null;
                                }
                            }
                            switch (attributeType.toLowerCase()) {
                                case "numeric": {
                                    columnType = ColumnType.NUMBER;
                                    break;
                                }
                                case "int": 
                                case "integer": 
                                case "short": {
                                    columnType = ColumnType.INTEGER;
                                    break;
                                }
                                case "real": 
                                case "double": 
                                case "float": {
                                    columnType = ColumnType.DOUBLE;
                                    break;
                                }
                                case "string": {
                                    columnType = ColumnType.STRING;
                                    break;
                                }
                                case "date": {
                                    columnType = ColumnType.DATE;
                                    break;
                                }
                                default: {
                                    if (indexOfCurly == -1) {
                                        logger.info("{}: Unrecognized data-type for attribute '{}': {}. Mapping to STRING column type.", new Object[]{this.resource.getName(), attributeName, attributeType});
                                    }
                                    columnType = ColumnType.STRING;
                                }
                            }
                            MutableColumn column = new MutableColumn(attributeName, columnType, (Table)table);
                            column.setRemarks(attributeParam == null ? attributeType : attributeType + " " + attributeParam);
                            column.setColumnNumber(table.getColumnCount());
                            table.addColumn((Column)column);
                            break;
                        }
                        case "@data": {
                            inHeader = false;
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return schema;
    }

    private String trimString(String string) {
        if (string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private BufferedReader createReader() {
        return FileHelper.getBufferedReader((InputStream)this.resource.read(), (Charset)CHARSET);
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.resource.getName();
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        BufferedReader reader = this.createReader();
        try {
            String line = reader.readLine();
            while (line != null && (ArffDataContext.isIgnoreLine(line = line.trim()) || !line.toLowerCase().equals(SECTION_ANNOTATION_DATA))) {
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArffDataSet dataSet = new ArffDataSet(this.resource, columns, reader);
        if (maxRows > -1) {
            return new MaxRowsDataSet((DataSet)dataSet, maxRows);
        }
        return dataSet;
    }

    protected static boolean isIgnoreLine(String line) {
        if (line.trim().isEmpty()) {
            return true;
        }
        return line.startsWith("%");
    }
}

