/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.arff;

import com.opencsv.CSVParser;
import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.arff.ArffDataContext;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.Resource;

final class ArffDataSet
extends AbstractDataSet {
    private final ICSVParser csvParser = new CSVParser(',', '\'');
    private final Resource resource;
    private final BufferedReader reader;
    private final List<Column> columns;
    private String line;

    public ArffDataSet(Resource resource, List<Column> columns, BufferedReader reader) {
        super(columns.stream().map(c -> new SelectItem(c)).collect(Collectors.toList()));
        this.resource = resource;
        this.columns = columns;
        this.reader = reader;
    }

    public boolean next() {
        try {
            this.line = this.reader.readLine();
            while (this.line != null && ArffDataContext.isIgnoreLine(this.line)) {
                this.line = this.reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.line != null;
    }

    public Row getRow() {
        String[] stringValues;
        if (this.line == null) {
            return null;
        }
        try {
            stringValues = this.csvParser.parseLine(this.line);
        }
        catch (IOException e) {
            throw new UncheckedIOException(this.resource.getName() + ": Failed to CSV-parse data line: " + this.line, e);
        }
        Object[] values = new Object[this.columns.size()];
        for (int i = 0; i < values.length; ++i) {
            Column column = this.columns.get(i);
            int index = column.getColumnNumber();
            String stringValue = stringValues[index];
            values[i] = this.convertValue(stringValue, column);
        }
        return new DefaultRow(this.getHeader(), values);
    }

    private Object convertValue(String stringValue, Column column) {
        ColumnType type = column.getType();
        if (type.isNumber()) {
            if (stringValue.isEmpty() || "?".equals(stringValue)) {
                return null;
            }
            Number n = NumberComparator.toNumber((Object)stringValue);
            if (type == ColumnType.INTEGER) {
                return n.intValue();
            }
            return n;
        }
        if (type.isTimeBased()) {
            String columnRemarks = column.getRemarks();
            SimpleDateFormat dateFormat = columnRemarks.toLowerCase().startsWith("date ") ? new SimpleDateFormat(columnRemarks.substring(5)) : new SimpleDateFormat("yyyy-MM-dd");
            try {
                return dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                throw new IllegalStateException(this.resource.getName() + ": Failed to parse '" + stringValue + "' using format '" + dateFormat.toPattern() + "'", e);
            }
        }
        return stringValue;
    }

    public void close() {
        super.close();
    }
}

