/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.couchdb.CouchDbDataContext;
import org.apache.metamodel.couchdb.CouchDbUpdateCallback;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.schema.Table;
import org.ektorp.CouchDbConnector;

final class CouchDbRowDeletionBuilder
extends AbstractRowDeletionBuilder {
    private final CouchDbUpdateCallback _updateCallback;

    public CouchDbRowDeletionBuilder(CouchDbUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MetaModelException {
        Table table = this.getTable();
        List whereItems = this.getWhereItems();
        CouchDbConnector connector = this._updateCallback.getConnector(table.getName());
        CouchDbDataContext dataContext = this._updateCallback.getDataContext();
        DataSet dataSet = dataContext.query().from(table).select(new String[]{"_id", "_rev"}).where((Iterable)whereItems).execute();
        try {
            while (dataSet.next()) {
                Row row = dataSet.getRow();
                String id = (String)row.getValue(0);
                String revision = (String)row.getValue(1);
                connector.delete(id, revision);
            }
        }
        finally {
            dataSet.close();
        }
    }
}

