/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import java.util.Iterator;
import java.util.List;
import org.apache.metamodel.couchdb.CouchDbDatabaseDocumentSource;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.ektorp.CouchDbInstance;

public class CouchDbSamplingDocumentSource
implements DocumentSource {
    private final CouchDbInstance _couchDbInstance;
    private final Iterator<String> _databaseNameIterator;
    private volatile CouchDbDatabaseDocumentSource _currentSource;

    public CouchDbSamplingDocumentSource(CouchDbInstance couchDbInstance) {
        this._couchDbInstance = couchDbInstance;
        List allDatabases = this._couchDbInstance.getAllDatabases();
        this._databaseNameIterator = allDatabases.iterator();
        this._currentSource = null;
    }

    public Document next() {
        Document next;
        if (this._currentSource == null) {
            if (!this._databaseNameIterator.hasNext()) {
                return null;
            }
            String databaseName = this._databaseNameIterator.next();
            while (databaseName.startsWith("_")) {
                if (!this._databaseNameIterator.hasNext()) {
                    return null;
                }
                databaseName = this._databaseNameIterator.next();
            }
            this._currentSource = new CouchDbDatabaseDocumentSource(this._couchDbInstance, databaseName, 500);
        }
        if ((next = this._currentSource.next()) == null) {
            if (this._currentSource != null) {
                this._currentSource.close();
            }
            this._currentSource = null;
            return this.next();
        }
        return next;
    }

    public void close() {
        if (this._currentSource != null) {
            this._currentSource.close();
        }
    }
}

