/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.couchdb.CouchDbUtils;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.StreamingViewResult;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;

final class CouchDbDatabaseDocumentSource
implements DocumentSource {
    private final CouchDbInstance _couchDbInstance;
    private final StreamingViewResult _view;
    private final String _databaseName;
    private final Iterator<ViewResult.Row> _rowIterator;
    private final AtomicBoolean _closed;

    public CouchDbDatabaseDocumentSource(CouchDbInstance couchDbInstance, String databaseName, int maxRows) {
        this._couchDbInstance = couchDbInstance;
        this._databaseName = databaseName;
        this._closed = new AtomicBoolean(false);
        CouchDbConnector tableConnector = this._couchDbInstance.createConnector(databaseName, false);
        this._view = maxRows > -1 ? tableConnector.queryForStreamingView(new ViewQuery().allDocs().includeDocs(true).limit(maxRows)) : tableConnector.queryForStreamingView(new ViewQuery().allDocs().includeDocs(true));
        this._rowIterator = this._view.iterator();
    }

    public Document next() {
        if (this._closed.get()) {
            return null;
        }
        if (!CouchDbUtils.safeHasNext(this._rowIterator)) {
            this.close();
            return this.next();
        }
        ViewResult.Row row = this._rowIterator.next();
        JsonNode docNode = row.getDocAsNode();
        Map<String, ?> map = CouchDbUtils.jsonNodeToMap(docNode);
        return new Document(this._databaseName, map, (Object)row);
    }

    public void close() {
        boolean closedBefore = this._closed.getAndSet(true);
        if (!closedBefore) {
            this._view.close();
        }
    }
}

