/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.couchdb.CouchDbDocumentConverter;
import org.apache.metamodel.couchdb.CouchDbTableCreationBuilder;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.InferentialSchemaBuilder;
import org.apache.metamodel.schema.builder.InferentialTableBuilder;

final class CouchDbInferentialSchemaBuilder
extends InferentialSchemaBuilder {
    private final String[] _databaseNames;

    public CouchDbInferentialSchemaBuilder() {
        this(null);
    }

    public CouchDbInferentialSchemaBuilder(String[] databaseNames) {
        super("CouchDB");
        this._databaseNames = databaseNames;
    }

    public void offerSources(DocumentSourceProvider documentSourceProvider) {
        if (this._databaseNames == null) {
            super.offerSources(documentSourceProvider);
        } else {
            for (String databaseName : this._databaseNames) {
                DocumentSource documentSource = documentSourceProvider.getDocumentSourceForTable(databaseName);
                this.offerDocumentSource(documentSource);
            }
        }
    }

    public DocumentConverter getDocumentConverter(Table table) {
        return new CouchDbDocumentConverter();
    }

    protected String determineTable(Document document) {
        String sourceCollectionName = document.getSourceCollectionName();
        return sourceCollectionName;
    }

    protected MutableTable buildTable(InferentialTableBuilder tableBuilder) {
        MutableTable table = super.buildTable(tableBuilder);
        CouchDbTableCreationBuilder.addMandatoryColumns(table);
        return table;
    }
}

