/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.query.SelectItem;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticSearchDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(AbstractElasticSearchDataSet.class);
    protected final AtomicBoolean _closed;
    protected SearchResponse _searchResponse;
    protected SearchHit _currentHit;
    protected int _hitIndex = 0;

    public AbstractElasticSearchDataSet(SearchResponse searchResponse, List<SelectItem> selectItems) {
        super(selectItems);
        this._searchResponse = searchResponse;
        this._closed = new AtomicBoolean(false);
    }

    public void close() {
        super.close();
        boolean closeNow = this._closed.compareAndSet(true, false);
        if (closeNow) {
            this.closeNow();
        }
    }

    protected abstract void closeNow();

    protected void finalize() throws Throwable {
        if (!this._closed.get()) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        SearchHit[] hits = this._searchResponse.getHits().getHits();
        if (hits.length == 0) {
            this._currentHit = null;
            return false;
        }
        if (this._hitIndex < hits.length) {
            this._currentHit = hits[this._hitIndex];
            ++this._hitIndex;
            return true;
        }
        String scrollId = this._searchResponse.getScrollId();
        if (scrollId == null) {
            this._currentHit = null;
            return false;
        }
        try {
            this._searchResponse = this.scrollSearchResponse(scrollId);
        }
        catch (IOException e) {
            logger.warn("Failed to scroll to the next search response set.", (Throwable)e);
            return false;
        }
        this._hitIndex = 0;
        return this.next();
    }

    protected abstract SearchResponse scrollSearchResponse(String var1) throws IOException;

    public Row getRow() {
        if (this._currentHit == null) {
            return null;
        }
        Map source = this._currentHit.getSource();
        String documentId = this._currentHit.getId();
        return ElasticSearchUtils.createRow(source, documentId, this.getHeader());
    }
}

