/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AbstractElasticSearchDataContext
extends QueryPostprocessDataContext
implements DataContext,
UpdateableDataContext {
    public static final TimeValue TIMEOUT_SCROLL = TimeValue.timeValueSeconds((long)60L);
    protected final String indexName;
    protected final List<SimpleTableDef> staticTableDefinitions;
    protected final List<SimpleTableDef> dynamicTableDefinitions = new ArrayList<SimpleTableDef>();

    public AbstractElasticSearchDataContext(String indexName, SimpleTableDef ... tableDefinitions) {
        super(false);
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid ElasticSearch Index name: " + indexName);
        }
        this.indexName = indexName;
        this.staticTableDefinitions = tableDefinitions == null || tableDefinitions.length == 0 ? Collections.emptyList() : Arrays.asList(tableDefinitions);
    }

    protected abstract SimpleTableDef[] detectSchema();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this.staticTableDefinitions) {
            this.addTable(theSchema, tableDef);
        }
        SimpleTableDef[] tables = this.detectSchema();
        AbstractElasticSearchDataContext abstractElasticSearchDataContext = this;
        synchronized (abstractElasticSearchDataContext) {
            this.dynamicTableDefinitions.clear();
            this.dynamicTableDefinitions.addAll(Arrays.asList(tables));
            for (SimpleTableDef tableDef : this.dynamicTableDefinitions) {
                List tableNames = theSchema.getTableNames();
                if (tableNames.contains(tableDef.getName())) continue;
                this.addTable(theSchema, tableDef);
            }
        }
        return theSchema;
    }

    private void addTable(MutableSchema theSchema, SimpleTableDef tableDef) {
        MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
        Column idColumn = table.getColumnByName("_id");
        if (idColumn != null && idColumn instanceof MutableColumn) {
            MutableColumn mutableColumn = (MutableColumn)idColumn;
            mutableColumn.setPrimaryKey(true);
        }
        theSchema.addTable((Table)table);
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    protected boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }

    protected static SimpleTableDef[] sortTables(List<SimpleTableDef> result) {
        SimpleTableDef[] tableDefArray = result.toArray(new SimpleTableDef[result.size()]);
        Arrays.sort(tableDefArray, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return tableDefArray;
    }
}

