/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.common;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.metamodel.util.TimeComparator;

public final class ElasticSearchDateConverter {
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat FALLBACK_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static Date tryToConvert(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        try {
            return DEFAULT_DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            try {
                return FALLBACK_DATE_FORMAT.parse(dateAsString);
            }
            catch (ParseException e1) {
                return TimeComparator.toDate((Object)dateAsString);
            }
        }
    }
}

