/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.common.ElasticSearchDateConverter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ElasticSearchUtils {
    public static final String FIELD_ID = "_id";
    public static final String SYSTEM_PROPERTY_STRIP_INVALID_FIELD_CHARS = "metamodel.elasticsearch.strip_invalid_field_chars";

    public static QueryBuilder getMissingQuery(String fieldName) {
        return new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(fieldName));
    }

    public static QueryBuilder getExistsQuery(String fieldName) {
        return new ExistsQueryBuilder(fieldName);
    }

    public static Map<String, ?> getMappingSource(MutableTable table) {
        if (table.getColumnByName(FIELD_ID) == null) {
            MutableColumn idColumn = new MutableColumn(FIELD_ID, ColumnType.STRING).setTable((Table)table).setPrimaryKey(true);
            table.addColumn(0, (Column)idColumn);
        }
        LinkedHashMap propertiesMap = new LinkedHashMap();
        for (Column column : table.getColumns()) {
            String columnName = column.getName();
            if (FIELD_ID.equals(columnName)) continue;
            String fieldName = ElasticSearchUtils.getValidatedFieldName(columnName);
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            String type = ElasticSearchUtils.getType(column);
            propertyMap.put("type", type);
            propertiesMap.put(fieldName, propertyMap);
        }
        HashMap mapping = new HashMap();
        mapping.put("properties", propertiesMap);
        return mapping;
    }

    public static String getValidatedFieldName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (fieldName.contains(".") || fieldName.contains("#") || fieldName.contains("*")) {
            if ("true".equalsIgnoreCase(System.getProperty(SYSTEM_PROPERTY_STRIP_INVALID_FIELD_CHARS, "true"))) {
                fieldName = fieldName.replace('.', '_').replace('#', '_').replace('*', '_');
            } else {
                throw new IllegalArgumentException("Field name '" + fieldName + "' contains illegal character (.#*)");
            }
        }
        return fieldName;
    }

    private static String getType(Column column) {
        String nativeType = column.getNativeType();
        if (!Strings.isNullOrEmpty((String)nativeType)) {
            return nativeType;
        }
        ColumnType type = column.getType();
        if (type == null) {
            throw new IllegalStateException("No column type specified for '" + column.getName() + "' - cannot build ElasticSearch mapping without type.");
        }
        if (type.isLiteral()) {
            return "text";
        }
        if (type == ColumnType.FLOAT) {
            return "float";
        }
        if (type == ColumnType.DOUBLE || type == ColumnType.NUMERIC || type == ColumnType.NUMBER) {
            return "double";
        }
        if (type == ColumnType.SMALLINT) {
            return "short";
        }
        if (type == ColumnType.TINYINT) {
            return "byte";
        }
        if (type == ColumnType.INTEGER) {
            return "integer";
        }
        if (type == ColumnType.DATE || type == ColumnType.TIMESTAMP) {
            return "date";
        }
        if (type == ColumnType.BINARY || type == ColumnType.VARBINARY) {
            return "binary";
        }
        if (type == ColumnType.BOOLEAN || type == ColumnType.BIT) {
            return "boolean";
        }
        if (type == ColumnType.MAP) {
            return "object";
        }
        throw new UnsupportedOperationException("Unsupported column type '" + type.getName() + "' of column '" + column.getName() + "' - cannot translate to an ElasticSearch type.");
    }

    public static QueryBuilder createQueryBuilderForSimpleWhere(List<FilterItem> whereItems, LogicalOperator logicalOperator) {
        if (whereItems.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        ArrayList<QueryBuilder> children = new ArrayList<QueryBuilder>(whereItems.size());
        for (FilterItem item : whereItems) {
            QueryBuilder itemQueryBuilder = ElasticSearchUtils.createFilterItemQueryBuilder(item);
            if (itemQueryBuilder == null) {
                return null;
            }
            children.add(itemQueryBuilder);
        }
        if (children.size() == 1) {
            return (QueryBuilder)children.get(0);
        }
        BoolQueryBuilder result = QueryBuilders.boolQuery();
        for (QueryBuilder child : children) {
            switch (logicalOperator) {
                case AND: {
                    result.must(child);
                }
                case OR: {
                    result.should(child);
                }
            }
        }
        return result;
    }

    private static QueryBuilder createFilterItemQueryBuilder(FilterItem filterItem) {
        QueryBuilder itemQueryBuilder;
        if (filterItem.isCompoundFilter()) {
            List<FilterItem> childItems = Arrays.asList(filterItem.getChildItems());
            itemQueryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(childItems, filterItem.getLogicalOperator());
        } else {
            Column column = filterItem.getSelectItem().getColumn();
            if (column == null) {
                return null;
            }
            itemQueryBuilder = ElasticSearchUtils.createQueryBuilderForOperator(filterItem, column);
        }
        return itemQueryBuilder;
    }

    private static QueryBuilder createQueryBuilderForOperator(FilterItem filterItem, Column column) {
        if (OperatorType.EQUALS_TO.equals(filterItem.getOperator())) {
            if (filterItem.getOperand() == null) {
                return ElasticSearchUtils.getMissingQuery(column.getName());
            }
            return ElasticSearchUtils.matchOrTermQuery(column, filterItem.getOperand());
        }
        if (OperatorType.DIFFERENT_FROM.equals(filterItem.getOperator())) {
            if (filterItem.getOperand() == null) {
                return ElasticSearchUtils.getExistsQuery(column.getName());
            }
            return QueryBuilders.boolQuery().mustNot(ElasticSearchUtils.matchOrTermQuery(column, filterItem.getOperand()));
        }
        if (OperatorType.IN.equals(filterItem.getOperator())) {
            List operands = CollectionUtils.toList((Object)filterItem.getOperand());
            if (column.getType().isLiteral()) {
                return ElasticSearchUtils.createMultipleValuesQueryBuilder(column.getName(), operands);
            }
            return QueryBuilders.termsQuery((String)column.getName(), (Collection)operands);
        }
        return null;
    }

    private static QueryBuilder matchOrTermQuery(Column column, Object operand) {
        if (column.getType().isLiteral()) {
            return QueryBuilders.matchQuery((String)column.getName(), (Object)operand);
        }
        return QueryBuilders.termQuery((String)column.getName(), (Object)operand);
    }

    private static QueryBuilder createMultipleValuesQueryBuilder(String columnName, List<?> operands) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (Object value : operands) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)columnName, (Object)value.toString()));
        }
        return boolQueryBuilder;
    }

    public static ColumnType getColumnTypeFromElasticSearchType(String metaDataFieldType) {
        ColumnType columnType = metaDataFieldType.startsWith("date") ? ColumnType.DATE : (metaDataFieldType.equals("long") ? ColumnType.BIGINT : (metaDataFieldType.equals("string") ? ColumnType.STRING : (metaDataFieldType.equals("float") ? ColumnType.FLOAT : (metaDataFieldType.equals("boolean") ? ColumnType.BOOLEAN : (metaDataFieldType.equals("double") ? ColumnType.DOUBLE : ColumnType.STRING)))));
        return columnType;
    }

    public static Row createRow(Map<String, Object> sourceMap, String documentId, DataSetHeader header) {
        Object[] values = new Object[header.size()];
        for (int i = 0; i < values.length; ++i) {
            SelectItem selectItem = header.getSelectItem(i);
            Column column = selectItem.getColumn();
            assert (column != null);
            assert (selectItem.getAggregateFunction() == null);
            assert (selectItem.getScalarFunction() == null);
            if (column.isPrimaryKey()) {
                values[i] = documentId;
                continue;
            }
            if (sourceMap == null) continue;
            Object value = sourceMap.get(column.getName());
            if (column.getType() == ColumnType.DATE) {
                Date valueToDate = ElasticSearchDateConverter.tryToConvert((String)value);
                if (valueToDate == null) {
                    values[i] = value;
                    continue;
                }
                values[i] = valueToDate;
                continue;
            }
            if (column.getType() == ColumnType.MAP && value == null) {
                HashMap valueMap = new HashMap();
                sourceMap.keySet().stream().filter(fieldName -> fieldName.startsWith(column.getName() + ".")).forEach(fieldName -> ElasticSearchUtils.evaluateField(sourceMap, valueMap, fieldName, fieldName.substring(fieldName.indexOf(46) + 1)));
                if (valueMap.isEmpty()) continue;
                values[i] = valueMap;
                continue;
            }
            values[i] = value;
        }
        return new DefaultRow(header, values);
    }

    private static void evaluateField(Map<String, Object> sourceMap, Map<String, Object> valueMap, String sourceFieldName, String subFieldName) {
        if (subFieldName.contains(".")) {
            Map nestedValueMap = (Map)valueMap.computeIfAbsent(subFieldName.substring(0, subFieldName.indexOf(46)), key -> ElasticSearchUtils.createNestedValueMap(valueMap, key));
            ElasticSearchUtils.evaluateField(sourceMap, nestedValueMap, sourceFieldName, subFieldName.substring(subFieldName.indexOf(46) + 1));
        } else {
            valueMap.put(subFieldName, sourceMap.get(sourceFieldName));
        }
    }

    private static Object createNestedValueMap(Map<String, Object> valueMap, String nestedFieldName) {
        HashMap nestedValueMap = new HashMap();
        valueMap.put(nestedFieldName, nestedValueMap);
        return nestedValueMap;
    }
}

