/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.IndicesAdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchCreateTableBuilder
extends AbstractTableCreationBuilder<ElasticSearchUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchCreateTableBuilder.class);

    public ElasticSearchCreateTableBuilder(ElasticSearchUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        Map source = ElasticSearchUtils.getMappingSource((MutableTable)table);
        ElasticSearchDataContext dataContext = ((ElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        IndicesAdminClient indicesAdmin = dataContext.getElasticSearchClient().admin().indices();
        String indexName = dataContext.getIndexName();
        PutMappingRequestBuilder requestBuilder = new PutMappingRequestBuilder(indicesAdmin).setIndices(new String[]{indexName}).setType(table.getName());
        requestBuilder.setSource(source);
        PutMappingResponse result = (PutMappingResponse)requestBuilder.execute().actionGet();
        logger.debug("PutMapping response: acknowledged={}", (Object)result.isAcknowledged());
        MutableSchema schema = (MutableSchema)this.getSchema();
        schema.addTable(table);
        return table;
    }
}

