/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.elasticsearch.nativeclient.NativeElasticSearchUtils;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectLookupContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataContext
extends QueryPostprocessDataContext
implements DataContext,
UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataContext.class);
    public static final TimeValue TIMEOUT_SCROLL = TimeValue.timeValueSeconds((long)60L);
    private final Client elasticSearchClient;
    private final String indexName;
    private final List<SimpleTableDef> staticTableDefinitions;
    private final List<SimpleTableDef> dynamicTableDefinitions = new ArrayList<SimpleTableDef>();

    public ElasticSearchDataContext(Client client, String indexName, SimpleTableDef ... tableDefinitions) {
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid ElasticSearch Index name: " + indexName);
        }
        this.elasticSearchClient = client;
        this.indexName = indexName;
        this.staticTableDefinitions = Arrays.asList(tableDefinitions);
        this.dynamicTableDefinitions.addAll(Arrays.asList(this.detectSchema()));
    }

    public ElasticSearchDataContext(Client client, String indexName) {
        this(client, indexName, new SimpleTableDef[0]);
    }

    private SimpleTableDef[] detectSchema() {
        logger.info("Detecting schema for index '{}'", (Object)this.indexName);
        ClusterStateRequestBuilder clusterStateRequestBuilder = this.getElasticSearchClient().admin().cluster().prepareState();
        try {
            Method method;
            byte majorVersion = Version.CURRENT.major;
            String[] methodArgument = new String[]{this.indexName};
            if (majorVersion == 0) {
                method = ClusterStateRequestBuilder.class.getMethod("setFilterIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            } else {
                method = ClusterStateRequestBuilder.class.getMethod("setIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            }
        }
        catch (Exception e) {
            logger.error("Failed to set index name on ClusterStateRequestBuilder, version {}", (Object)Version.CURRENT, (Object)e);
            throw new MetaModelException("Failed to create request for index information needed to detect schema", e);
        }
        ClusterState cs = ((ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet()).getState();
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        IndexMetaData imd = cs.getMetaData().index(this.indexName);
        if (imd == null) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.");
        } else {
            ImmutableOpenMap mappings = imd.getMappings();
            ObjectLookupContainer documentTypes = mappings.keys();
            for (Object documentTypeCursor : documentTypes) {
                String documentType = ((ObjectCursor)documentTypeCursor).value.toString();
                try {
                    SimpleTableDef table = ElasticSearchDataContext.detectTable(cs, this.indexName, documentType);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document type '{}'", (Object)documentType, (Object)e);
                }
            }
        }
        SimpleTableDef[] tableDefArray = result.toArray(new SimpleTableDef[result.size()]);
        Arrays.sort(tableDefArray, new Comparator<SimpleTableDef>(){

            @Override
            public int compare(SimpleTableDef o1, SimpleTableDef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tableDefArray;
    }

    public static SimpleTableDef detectTable(ClusterState cs, String indexName, String documentType) throws Exception {
        logger.debug("Detecting table for document type '{}' in index '{}'", (Object)documentType, (Object)indexName);
        IndexMetaData imd = cs.getMetaData().index(indexName);
        if (imd == null) {
            throw new IllegalArgumentException("No such index: " + indexName);
        }
        MappingMetaData mappingMetaData = imd.mapping(documentType);
        if (mappingMetaData == null) {
            throw new IllegalArgumentException("No such document type in index '" + indexName + "': " + documentType);
        }
        Map mp = mappingMetaData.getSourceAsMap();
        Object metadataProperties = mp.get("properties");
        if (metadataProperties != null && metadataProperties instanceof Map) {
            Map metadataPropertiesMap = (Map)metadataProperties;
            ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse(metadataPropertiesMap);
            SimpleTableDef std = new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
            return std;
        }
        throw new IllegalArgumentException("No mapping properties defined for document type '" + documentType + "' in index: " + indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this.staticTableDefinitions) {
            this.addTable(theSchema, tableDef);
        }
        SimpleTableDef[] tables = this.detectSchema();
        ElasticSearchDataContext elasticSearchDataContext = this;
        synchronized (elasticSearchDataContext) {
            this.dynamicTableDefinitions.clear();
            this.dynamicTableDefinitions.addAll(Arrays.asList(tables));
            for (SimpleTableDef tableDef : this.dynamicTableDefinitions) {
                List<String> tableNames = Arrays.asList(theSchema.getTableNames());
                if (tableNames.contains(tableDef.getName())) continue;
                this.addTable(theSchema, tableDef);
            }
        }
        return theSchema;
    }

    private void addTable(MutableSchema theSchema, SimpleTableDef tableDef) {
        MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
        Column idColumn = table.getColumnByName("_id");
        if (idColumn != null && idColumn instanceof MutableColumn) {
            MutableColumn mutableColumn = (MutableColumn)idColumn;
            mutableColumn.setPrimaryKey(true);
        }
        theSchema.addTable(table);
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.indexName;
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchRequestBuilder searchRequest = this.createSearchRequest(table, firstRow, maxRows, queryBuilder);
            SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
            return new ElasticSearchDataSet(this.elasticSearchClient, response, selectItems, false);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        SearchRequestBuilder searchRequest = this.createSearchRequest(table, 1, maxRows, null);
        SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
        return new ElasticSearchDataSet(this.elasticSearchClient, response, columns, false);
    }

    private SearchRequestBuilder createSearchRequest(Table table, int firstRow, int maxRows, QueryBuilder queryBuilder) {
        String documentType = table.getName();
        SearchRequestBuilder searchRequest = this.elasticSearchClient.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{documentType});
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.setFrom(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.setSize(maxRows);
        } else {
            searchRequest.setScroll(TIMEOUT_SCROLL);
        }
        if (queryBuilder != null) {
            searchRequest.setQuery(queryBuilder);
        }
        return searchRequest;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        String id;
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        GetResponse response = (GetResponse)this.elasticSearchClient.prepareGet(this.indexName, documentType, id = keyValue.toString()).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        Map source = response.getSource();
        String documentId = response.getId();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return NativeElasticSearchUtils.createRow(source, documentId, (DataSetHeader)header);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        CountResponse response = (CountResponse)this.elasticSearchClient.prepareCount(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType)).execute().actionGet();
        return response.getCount();
    }

    private boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }

    public void executeUpdate(UpdateScript update) {
        ElasticSearchUpdateCallback callback = new ElasticSearchUpdateCallback(this);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
    }

    public Client getElasticSearchClient() {
        return this.elasticSearchClient;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

