/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.lang.reflect.Method;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.drop.AbstractTableDropBuilder;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchDropTableBuilder
extends AbstractTableDropBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDropTableBuilder.class);
    private final ElasticSearchUpdateCallback _updateCallback;

    public ElasticSearchDropTableBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        ElasticSearchDataContext dataContext = this._updateCallback.getDataContext();
        Table table = this.getTable();
        String documentType = table.getName();
        logger.info("Deleting mapping / document type: {}", (Object)documentType);
        Client client = dataContext.getElasticSearchClient();
        IndicesAdminClient indicesAdminClient = client.admin().indices();
        String indexName = dataContext.getIndexName();
        DeleteMappingRequestBuilder requestBuilder = new DeleteMappingRequestBuilder(indicesAdminClient).setIndices(new String[]{indexName});
        this.setType(requestBuilder, documentType);
        DeleteMappingResponse result = (DeleteMappingResponse)requestBuilder.execute().actionGet();
        logger.debug("Delete mapping response: acknowledged={}", (Object)result.isAcknowledged());
        MutableSchema schema = (MutableSchema)table.getSchema();
        schema.removeTable(table);
    }

    private void setType(DeleteMappingRequestBuilder requestBuilder, String documentType) {
        Object argument;
        Method method;
        try {
            try {
                method = requestBuilder.getClass().getDeclaredMethod("setType", String[].class);
                argument = new String[]{documentType};
            }
            catch (NoSuchMethodException e) {
                logger.debug("No setType(String[]) method found, trying with a single String instead", (Throwable)e);
                method = requestBuilder.getClass().getDeclaredMethod("setType", String.class);
                argument = documentType;
            }
        }
        catch (Exception e) {
            logger.error("Failed to resolve DeleteMappingRequestBuilder.setType(...) method", (Throwable)e);
            throw new IllegalStateException("Failed to resolve DeleteMappingRequestBuilder.setType(...) method", e);
        }
        try {
            method.setAccessible(true);
            method.invoke((Object)requestBuilder, argument);
        }
        catch (Exception e) {
            logger.error("Failed to invoke {}", (Object)method, (Object)e);
            throw new IllegalStateException("Failed to invoke " + method, e);
        }
    }
}

