/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.util.Date;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.common.ElasticSearchDateConverter;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;

final class NativeElasticSearchUtils {
    NativeElasticSearchUtils() {
    }

    public static Row createRow(Map<String, Object> sourceMap, String documentId, DataSetHeader header) {
        Object[] values = new Object[header.size()];
        for (int i = 0; i < values.length; ++i) {
            SelectItem selectItem = header.getSelectItem(i);
            Column column = selectItem.getColumn();
            assert (column != null);
            assert (selectItem.getAggregateFunction() == null);
            assert (selectItem.getScalarFunction() == null);
            if (column.isPrimaryKey()) {
                values[i] = documentId;
                continue;
            }
            Object value = sourceMap.get(column.getName());
            if (column.getType() == ColumnType.DATE) {
                Date valueToDate = ElasticSearchDateConverter.tryToConvert((String)((String)value));
                if (valueToDate == null) {
                    values[i] = value;
                    continue;
                }
                values[i] = valueToDate;
                continue;
            }
            values[i] = value;
        }
        return new DefaultRow(header, values);
    }
}

