/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ElasticSearchDataContextFactory
implements DataContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataContextFactory.class);

    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        switch (properties.getDataContextType()) {
            case "elasticsearch": 
            case "es-node": 
            case "elasticsearch-node": 
            case "es-transport": 
            case "elasticsearch-transport": {
                return this.acceptsInternal(properties);
            }
        }
        return false;
    }

    private boolean acceptsInternal(DataContextProperties properties) {
        String clientType = this.getClientType(properties);
        if (clientType == null) {
            return false;
        }
        if (!("node".equals(clientType) || properties.getHostname() != null && properties.getPort() != null)) {
            return false;
        }
        if (this.getIndex(properties) == null) {
            return false;
        }
        return this.getCluster(properties) != null;
    }

    private String getClientType(DataContextProperties properties) {
        switch (properties.getDataContextType()) {
            case "elasticsearch-node": 
            case "es-node": {
                return "node";
            }
            case "elasticsearch-transport": 
            case "es-transport": {
                return "transport";
            }
        }
        String clientType = (String)properties.toMap().get("clientType");
        return clientType;
    }

    private String getIndex(DataContextProperties properties) {
        String databaseName = properties.getDatabaseName();
        if (databaseName == null) {
            return (String)properties.toMap().get("index");
        }
        return databaseName;
    }

    private String getCluster(DataContextProperties properties) {
        return (String)properties.toMap().get("cluster");
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        Client client = this.createTransportClient(properties);
        String indexName = this.getIndex(properties);
        SimpleTableDef[] tableDefinitions = properties.getTableDefs();
        return new ElasticSearchDataContext(client, indexName, tableDefinitions);
    }

    private Client createTransportClient(DataContextProperties properties) {
        Settings settings = Settings.builder().put("name", "MetaModel").put("cluster.name", this.getCluster(properties)).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        try {
            client.addTransportAddress(new TransportAddress(InetAddress.getByName(properties.getHostname()), properties.getPort().intValue()));
        }
        catch (UnknownHostException e) {
            logger.warn("no IP address for the host with name \"{}\" could be found.", (Object)properties.getHostname());
        }
        return client;
    }
}

