/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class ElasticSearchInsertBuilder
extends AbstractRowInsertionBuilder<ElasticSearchUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchInsertBuilder.class);

    public ElasticSearchInsertBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        ElasticSearchDataContext dataContext = ((ElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        Client client = dataContext.getElasticSearchClient();
        String indexName = dataContext.getIndexName();
        String documentType = this.getTable().getName();
        IndexRequestBuilder requestBuilder = ((IndexRequestBuilder)new IndexRequestBuilder((ElasticsearchClient)client, IndexAction.INSTANCE).setIndex(indexName)).setType(documentType);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String name = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(name)) {
                if (value == null) continue;
                requestBuilder.setId(value.toString());
                continue;
            }
            valueMap.put(name, value);
        }
        assert (!valueMap.isEmpty());
        requestBuilder.setSource(valueMap);
        IndexResponse result = (IndexResponse)requestBuilder.execute().actionGet();
        logger.debug("Inserted document: id={}", (Object)result.getId());
        client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
    }
}

