/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.indices.Refresh;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchCreateTableBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchDeleteBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchDropTableBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchInsertBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class JestElasticSearchUpdateCallback
extends AbstractUpdateCallback {
    public JestElasticSearchUpdateCallback(ElasticSearchRestDataContext dataContext) {
        super((DataContext)dataContext);
    }

    public ElasticSearchRestDataContext getDataContext() {
        return (ElasticSearchRestDataContext)super.getDataContext();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new JestElasticSearchCreateTableBuilder(this, schema, name);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchDropTableBuilder(this, table);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchInsertBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchDeleteBuilder(this, table);
    }

    public void onExecuteUpdateFinished() {
        String indexName = this.getDataContext().getIndexName();
        Refresh refresh = ((Refresh.Builder)new Refresh.Builder().addIndex(indexName)).build();
        JestClientExecutor.execute(this.getDataContext().getElasticSearchClient(), refresh, false);
    }
}

