/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.indices.Refresh;
import java.util.List;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchCreateTableBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchDeleteBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchDropTableBuilder;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchInsertBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JestElasticSearchUpdateCallback
extends AbstractUpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(JestElasticSearchUpdateCallback.class);
    private static final int BULK_BUFFER_SIZE = 1000;
    private Bulk.Builder bulkBuilder;
    private int bulkActionCount = 0;
    private final boolean isBatch;

    public JestElasticSearchUpdateCallback(ElasticSearchRestDataContext dataContext, boolean isBatch) {
        super((DataContext)dataContext);
        this.isBatch = isBatch;
    }

    private boolean isBatch() {
        return this.isBatch;
    }

    public ElasticSearchRestDataContext getDataContext() {
        return (ElasticSearchRestDataContext)super.getDataContext();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new JestElasticSearchCreateTableBuilder(this, schema, name);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchDropTableBuilder(this, table);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchInsertBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new JestElasticSearchDeleteBuilder(this, table);
    }

    public void onExecuteUpdateFinished() {
        if (this.isBatch()) {
            this.flushBulkActions();
        }
        String indexName = this.getDataContext().getIndexName();
        Refresh refresh = ((Refresh.Builder)new Refresh.Builder().addIndex(indexName)).build();
        JestClientExecutor.execute(this.getDataContext().getElasticSearchClient(), refresh, false);
    }

    private void flushBulkActions() {
        if (this.bulkBuilder == null || this.bulkActionCount == 0) {
            return;
        }
        Bulk bulk = this.getBulkBuilder().build();
        logger.info("Flushing {} actions to ElasticSearch index {}", (Object)this.bulkActionCount, (Object)this.getDataContext().getIndexName());
        this.executeBlocking((Action<?>)bulk);
        this.bulkActionCount = 0;
        this.bulkBuilder = null;
    }

    public void execute(Action<?> action) {
        if (this.isBatch() && action instanceof BulkableAction) {
            Bulk.Builder bulkBuilder = this.getBulkBuilder();
            bulkBuilder.addAction((BulkableAction)action);
            ++this.bulkActionCount;
            if (this.bulkActionCount == 1000) {
                this.flushBulkActions();
            }
        } else {
            this.executeBlocking(action);
        }
    }

    private void executeBlocking(Action<?> action) {
        Object result = JestClientExecutor.execute(this.getDataContext().getElasticSearchClient(), action);
        if (!result.isSucceeded()) {
            if (result instanceof BulkResult) {
                List failedItems = ((BulkResult)result).getFailedItems();
                for (int i = 0; i < failedItems.size(); ++i) {
                    BulkResult.BulkResultItem failedItem = (BulkResult.BulkResultItem)failedItems.get(i);
                    logger.error("Bulk failed with item no. {} of {}: id={} op={} status={} error={}", new Object[]{i + 1, failedItems.size(), failedItem.id, failedItem.operation, failedItem.status, failedItem.error});
                }
            }
            throw new MetaModelException(result.getResponseCode() + " - " + result.getErrorMessage());
        }
    }

    private Bulk.Builder getBulkBuilder() {
        if (this.bulkBuilder == null) {
            this.bulkBuilder = new Bulk.Builder();
            this.bulkBuilder.defaultIndex(this.getDataContext().getIndexName());
        }
        return this.bulkBuilder;
    }
}

