/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.schema.ColumnType;

final class JestElasticSearchMetaDataParser {
    JestElasticSearchMetaDataParser() {
    }

    public static ElasticSearchMetaData parse(JsonObject metaDataInfo) {
        int columns = metaDataInfo.entrySet().size() + 1;
        String[] fieldNames = new String[columns];
        ColumnType[] columnTypes = new ColumnType[columns];
        fieldNames[0] = "_id";
        columnTypes[0] = ColumnType.STRING;
        int i = 1;
        for (Map.Entry metaDataField : metaDataInfo.entrySet()) {
            JsonElement fieldMetadata = (JsonElement)metaDataField.getValue();
            fieldNames[i] = (String)metaDataField.getKey();
            columnTypes[i] = JestElasticSearchMetaDataParser.getColumnTypeFromMetadataField(fieldMetadata);
            ++i;
        }
        return new ElasticSearchMetaData(fieldNames, columnTypes);
    }

    private static ColumnType getColumnTypeFromMetadataField(JsonElement fieldMetadata) {
        JsonElement typeElement = ((JsonObject)fieldMetadata).get("type");
        if (typeElement != null) {
            String metaDataFieldType = typeElement.getAsString();
            return ElasticSearchUtils.getColumnTypeFromElasticSearchType((String)metaDataFieldType);
        }
        return ColumnType.STRING;
    }
}

