/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUtil;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchRestDataContextFactory
implements DataContextFactory {
    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        switch (properties.getDataContextType()) {
            case "elasticsearch": {
                String url = properties.getUrl();
                return url != null && url.startsWith("http") && this.acceptsInternal(properties);
            }
            case "es-rest": 
            case "elasticsearch-rest": {
                return this.acceptsInternal(properties);
            }
        }
        return false;
    }

    private boolean acceptsInternal(DataContextProperties properties) {
        if (properties.getUrl() == null) {
            return false;
        }
        return this.getIndex(properties) != null;
    }

    private RestHighLevelClient createClient(DataContextProperties properties) throws MalformedURLException {
        URL url = new URL(properties.getUrl());
        return ElasticSearchRestUtil.createClient(new HttpHost(url.getHost(), url.getPort()), properties.getUsername(), properties.getPassword());
    }

    private String getIndex(DataContextProperties properties) {
        String databaseName = properties.getDatabaseName();
        if (databaseName == null) {
            properties.toMap().get("index");
        }
        return databaseName;
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        try {
            RestHighLevelClient client = this.createClient(properties);
            String indexName = this.getIndex(properties);
            SimpleTableDef[] tableDefinitions = properties.getTableDefs();
            return new ElasticSearchRestDataContext(client, indexName, tableDefinitions);
        }
        catch (MalformedURLException e) {
            throw new UnsupportedDataContextPropertiesException((Exception)e);
        }
    }
}

