/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.ElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.ElasticSearchUpdateCallback;
import org.apache.metamodel.elasticsearch.ElasticSearchUtils;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectLookupContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataContext
extends QueryPostprocessDataContext
implements DataContext,
UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataContext.class);
    public static final String FIELD_ID = "_id";
    public static final TimeValue TIMEOUT_SCROLL = TimeValue.timeValueSeconds((long)60L);
    private final Client elasticSearchClient;
    private final SimpleTableDef[] tableDefs;
    private final String indexName;

    public ElasticSearchDataContext(Client client, String indexName, SimpleTableDef ... tableDefs) {
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid ElasticSearch Index name: " + indexName);
        }
        this.elasticSearchClient = client;
        this.indexName = indexName;
        this.tableDefs = tableDefs;
    }

    public ElasticSearchDataContext(Client client, String indexName) {
        this(client, indexName, ElasticSearchDataContext.detectSchema(client, indexName));
    }

    public static SimpleTableDef[] detectSchema(Client client, String indexName) {
        logger.info("Detecting schema for index '{}'", (Object)indexName);
        ClusterStateRequestBuilder clusterStateRequestBuilder = client.admin().cluster().prepareState();
        try {
            Method method;
            byte majorVersion = Version.CURRENT.major;
            String[] methodArgument = new String[]{indexName};
            if (majorVersion == 0) {
                method = ClusterStateRequestBuilder.class.getMethod("setFilterIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            } else {
                method = ClusterStateRequestBuilder.class.getMethod("setIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            }
        }
        catch (Exception e) {
            logger.error("Failed to set index name on ClusterStateRequestBuilder, version {}", (Object)Version.CURRENT, (Object)e);
            throw new MetaModelException("Failed to create request for index information needed to detect schema", e);
        }
        ClusterState cs = ((ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet()).getState();
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        IndexMetaData imd = cs.getMetaData().index(indexName);
        if (imd == null) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.");
        } else {
            ImmutableOpenMap mappings = imd.getMappings();
            ObjectLookupContainer documentTypes = mappings.keys();
            for (ObjectCursor documentTypeCursor : documentTypes) {
                String documentType = documentTypeCursor.value.toString();
                try {
                    SimpleTableDef table = ElasticSearchDataContext.detectTable(cs, indexName, documentType);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document type '{}'", (Object)documentType, (Object)e);
                }
            }
        }
        SimpleTableDef[] tableDefArray = result.toArray(new SimpleTableDef[result.size()]);
        Arrays.sort(tableDefArray, new Comparator<SimpleTableDef>(){

            @Override
            public int compare(SimpleTableDef o1, SimpleTableDef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tableDefArray;
    }

    public static SimpleTableDef detectTable(ClusterState cs, String indexName, String documentType) throws Exception {
        logger.debug("Detecting table for document type '{}' in index '{}'", (Object)documentType, (Object)indexName);
        IndexMetaData imd = cs.getMetaData().index(indexName);
        if (imd == null) {
            throw new IllegalArgumentException("No such index: " + indexName);
        }
        MappingMetaData mappingMetaData = imd.mapping(documentType);
        if (mappingMetaData == null) {
            throw new IllegalArgumentException("No such document type in index '" + indexName + "': " + documentType);
        }
        Map mp = mappingMetaData.getSourceAsMap();
        Iterator it = mp.entrySet().iterator();
        Map.Entry pair = it.next();
        ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse(pair.getValue());
        return new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this.tableDefs) {
            MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
            Column idColumn = table.getColumnByName(FIELD_ID);
            if (idColumn != null && idColumn instanceof MutableColumn) {
                MutableColumn mutableColumn = (MutableColumn)idColumn;
                mutableColumn.setPrimaryKey(true);
            }
            theSchema.addTable(table);
        }
        return theSchema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.indexName;
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = this.createQueryBuilderForSimpleWhere(table, whereItems, LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchRequestBuilder searchRequest = this.createSearchRequest(table, firstRow, maxRows, queryBuilder);
            SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
            return new ElasticSearchDataSet(this.elasticSearchClient, response, selectItems, false);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        SearchRequestBuilder searchRequest = this.createSearchRequest(table, 1, maxRows, null);
        SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
        return new ElasticSearchDataSet(this.elasticSearchClient, response, columns, false);
    }

    private SearchRequestBuilder createSearchRequest(Table table, int firstRow, int maxRows, QueryBuilder queryBuilder) {
        String documentType = table.getName();
        SearchRequestBuilder searchRequest = this.elasticSearchClient.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{documentType});
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.setFrom(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.setSize(maxRows);
        } else {
            searchRequest.setScroll(TIMEOUT_SCROLL);
        }
        if (queryBuilder != null) {
            searchRequest.setQuery(queryBuilder);
        }
        return searchRequest;
    }

    protected QueryBuilder createQueryBuilderForSimpleWhere(Table table, List<FilterItem> whereItems, LogicalOperator logicalOperator) {
        if (whereItems.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        ArrayList<QueryBuilder> children = new ArrayList<QueryBuilder>(whereItems.size());
        for (FilterItem item : whereItems) {
            QueryBuilder itemQueryBuilder;
            if (item.isCompoundFilter()) {
                List<FilterItem> childItems = Arrays.asList(item.getChildItems());
                itemQueryBuilder = this.createQueryBuilderForSimpleWhere(table, childItems, item.getLogicalOperator());
                if (itemQueryBuilder == null) {
                    return null;
                }
            } else {
                Column column = item.getSelectItem().getColumn();
                if (column == null) {
                    return null;
                }
                String fieldName = column.getName();
                Object operand = item.getOperand();
                OperatorType operator = item.getOperator();
                switch (operator) {
                    case EQUALS_TO: {
                        itemQueryBuilder = QueryBuilders.termQuery((String)fieldName, (Object)operand);
                        break;
                    }
                    case DIFFERENT_FROM: {
                        itemQueryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (Object)operand));
                        break;
                    }
                    case IN: {
                        List operands = CollectionUtils.toList((Object)operand);
                        itemQueryBuilder = QueryBuilders.termsQuery((String)fieldName, (Collection)operands);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            children.add(itemQueryBuilder);
        }
        if (children.size() == 1) {
            return (QueryBuilder)children.get(0);
        }
        BoolQueryBuilder result = QueryBuilders.boolQuery();
        for (QueryBuilder child : children) {
            switch (logicalOperator) {
                case AND: {
                    result.must(child);
                }
                case OR: {
                    result.should(child);
                }
            }
        }
        return result;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        String id;
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        GetResponse response = (GetResponse)this.elasticSearchClient.prepareGet(this.indexName, documentType, id = keyValue.toString()).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        Map source = response.getSource();
        String documentId = response.getId();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return ElasticSearchUtils.createRow(source, documentId, (DataSetHeader)header);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        CountResponse response = (CountResponse)this.elasticSearchClient.prepareCount(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType)).execute().actionGet();
        return response.getCount();
    }

    private boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }

    public void executeUpdate(UpdateScript update) {
        ElasticSearchUpdateCallback callback = new ElasticSearchUpdateCallback(this);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
    }

    public Client getElasticSearchClient() {
        return this.elasticSearchClient;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

