/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.List;
import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.elasticsearch.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.ElasticSearchUpdateCallback;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDeleteBuilder.class);
    private final ElasticSearchUpdateCallback _updateCallback;

    public ElasticSearchDeleteBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        Table table = this.getTable();
        String documentType = table.getName();
        ElasticSearchDataContext dataContext = this._updateCallback.getDataContext();
        Client client = dataContext.getElasticSearchClient();
        String indexName = dataContext.getIndexName();
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = new DeleteByQueryRequestBuilder(client);
        deleteByQueryRequestBuilder.setIndices(new String[]{indexName});
        deleteByQueryRequestBuilder.setTypes(new String[]{documentType});
        List whereItems = this.getWhereItems();
        QueryBuilder queryBuilder = dataContext.createQueryBuilderForSimpleWhere(table, whereItems, LogicalOperator.AND);
        if (queryBuilder == null) {
            throw new UnsupportedOperationException("Could not push down WHERE items to delete by query request: " + whereItems);
        }
        deleteByQueryRequestBuilder.setQuery(queryBuilder);
        DeleteByQueryResponse response = (DeleteByQueryResponse)deleteByQueryRequestBuilder.execute().actionGet();
        if (logger.isDebugEnabled()) {
            Map headers = response.getHeaders();
            IndexDeleteByQueryResponse indexResponse = response.getIndex(indexName);
            Map indexHeaders = indexResponse.getHeaders();
            logger.debug("Deleted documents by query. Response headers: {}, Index headers: {}", (Object)headers, (Object)indexHeaders);
        }
    }
}

