/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.Map;
import org.apache.metamodel.elasticsearch.ElasticSearchMetaData;
import org.apache.metamodel.schema.ColumnType;

public class ElasticSearchMetaDataParser {
    public static ElasticSearchMetaData parse(Map<String, ?> metaDataInfo) {
        String[] fieldNames = new String[metaDataInfo.size() + 1];
        ColumnType[] columnTypes = new ColumnType[metaDataInfo.size() + 1];
        fieldNames[0] = "_id";
        columnTypes[0] = ColumnType.STRING;
        int i = 1;
        for (Map.Entry<String, ?> metaDataField : metaDataInfo.entrySet()) {
            Map fieldMetadata = (Map)metaDataField.getValue();
            fieldNames[i] = metaDataField.getKey();
            columnTypes[i] = ElasticSearchMetaDataParser.getColumnTypeFromMetadataField(fieldMetadata);
            ++i;
        }
        return new ElasticSearchMetaData(fieldNames, columnTypes);
    }

    private static ColumnType getColumnTypeFromMetadataField(Map<String, ?> fieldMetadata) {
        String metaDataFieldType = ElasticSearchMetaDataParser.getMetaDataFieldTypeFromMetaDataField(fieldMetadata);
        if (metaDataFieldType == null) {
            return ColumnType.STRING;
        }
        ColumnType columnType = metaDataFieldType.startsWith("date") ? ColumnType.DATE : (metaDataFieldType.equals("long") ? ColumnType.BIGINT : (metaDataFieldType.equals("string") ? ColumnType.STRING : (metaDataFieldType.equals("float") ? ColumnType.FLOAT : (metaDataFieldType.equals("boolean") ? ColumnType.BOOLEAN : (metaDataFieldType.equals("double") ? ColumnType.DOUBLE : ColumnType.STRING)))));
        return columnType;
    }

    private static String getMetaDataFieldTypeFromMetaDataField(Map<String, ?> metaDataField) {
        Object type = metaDataField.get("type");
        if (type == null) {
            return null;
        }
        return type.toString();
    }
}

