/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.excel.ExcelUpdateCallback;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

final class ExcelTableCreationBuilder
extends AbstractTableCreationBuilder<ExcelUpdateCallback> {
    public ExcelTableCreationBuilder(ExcelUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() {
        ExcelUpdateCallback updateCallback = (ExcelUpdateCallback)this.getUpdateCallback();
        MutableTable table = this.getTable();
        Sheet sheet = updateCallback.createSheet(table.getName());
        int lineNumber = updateCallback.getConfiguration().getColumnNameLineNumber();
        if (lineNumber != 0) {
            int zeroBasedLineNumber = lineNumber - 1;
            Row row = sheet.createRow(zeroBasedLineNumber);
            Column[] columns = table.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnNumber = column.getColumnNumber();
                row.createCell(columnNumber).setCellValue(column.getName());
            }
        }
        MutableSchema schema = (MutableSchema)table.getSchema();
        schema.addTable(table);
        return table;
    }
}

