/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.Date;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.excel.ExcelUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LazyRef;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;

final class ExcelInsertBuilder
extends AbstractRowInsertionBuilder<ExcelUpdateCallback> {
    public ExcelInsertBuilder(ExcelUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() {
        Object[] values = this.getValues();
        Style[] styles = this.getStyles();
        Row row = ((ExcelUpdateCallback)this.getUpdateCallback()).createRow(this.getTable().getName());
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            int columnNumber = columns[i].getColumnNumber();
            Cell cell = row.createCell(columnNumber);
            LazyRef cellStyle = new LazyRef<CellStyle>(){

                protected CellStyle fetch() {
                    return ((ExcelUpdateCallback)ExcelInsertBuilder.this.getUpdateCallback()).createCellStyle();
                }
            };
            if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else {
                cell.setCellValue(value.toString());
            }
            Style style = styles[i];
            if (style != null && !Style.NO_STYLE.equals(style)) {
                Style.Color backgroundColor;
                Style.Color foregroundColor;
                LazyRef<Font> font = new LazyRef<Font>(){

                    protected Font fetch() {
                        return ((ExcelUpdateCallback)ExcelInsertBuilder.this.getUpdateCallback()).createFont();
                    }
                };
                if (style.isBold()) {
                    ((Font)font.get()).setBoldweight((short)700);
                }
                if (style.isItalic()) {
                    ((Font)font.get()).setItalic(true);
                }
                if (style.isUnderline()) {
                    ((Font)font.get()).setUnderline((byte)1);
                }
                if (style.getFontSize() != null) {
                    Integer fontSize = style.getFontSize();
                    Style.SizeUnit sizeUnit = style.getFontSizeUnit();
                    if (sizeUnit == Style.SizeUnit.PERCENT) {
                        fontSize = this.convertFontPercentageToPt(fontSize);
                    }
                    ((Font)font.get()).setFontHeightInPoints(fontSize.shortValue());
                }
                if ((foregroundColor = style.getForegroundColor()) != null) {
                    short index = ((ExcelUpdateCallback)this.getUpdateCallback()).getColorIndex(foregroundColor);
                    ((Font)font.get()).setColor(index);
                }
                if (font.isFetched()) {
                    ((CellStyle)cellStyle.get()).setFont((Font)font.get());
                }
                if (style.getAlignment() != null) {
                    ((CellStyle)cellStyle.get()).setAlignment(this.getAlignment(style.getAlignment()));
                }
                if ((backgroundColor = style.getBackgroundColor()) != null) {
                    ((CellStyle)cellStyle.get()).setFillPattern((short)1);
                    ((CellStyle)cellStyle.get()).setFillForegroundColor(((ExcelUpdateCallback)this.getUpdateCallback()).getColorIndex(backgroundColor));
                }
            }
            if (value instanceof Date) {
                if (cellStyle.isFetched()) {
                    ((CellStyle)cellStyle.get()).setDataFormat(((ExcelUpdateCallback)this.getUpdateCallback()).getDateCellFormat());
                } else {
                    cellStyle = new LazyRef<CellStyle>(){

                        protected CellStyle fetch() {
                            return ((ExcelUpdateCallback)ExcelInsertBuilder.this.getUpdateCallback()).getDateCellStyle();
                        }
                    };
                    cellStyle.get();
                }
            }
            if (!cellStyle.isFetched()) continue;
            cell.setCellStyle((CellStyle)cellStyle.get());
        }
    }

    private Integer convertFontPercentageToPt(Integer percentage) {
        Double d = (double)percentage.intValue() * 11.0 / 100.0;
        return d.intValue();
    }

    private short getAlignment(Style.TextAlignment alignment) {
        switch (alignment) {
            case LEFT: {
                return 1;
            }
            case RIGHT: {
                return 3;
            }
            case CENTER: {
                return 2;
            }
            case JUSTIFY: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unknown alignment type: " + alignment);
    }
}

