/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.io.InputStream;
import java.util.List;
import org.apache.metamodel.data.RowPublisher;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.excel.XlsxRowCallback;
import org.apache.metamodel.excel.XlsxSheetToRowsHandler;
import org.apache.metamodel.excel.XlsxStopParsingException;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class XlsxRowPublisherAction
implements Action<RowPublisher> {
    private static final Logger logger = LoggerFactory.getLogger(XlsxRowPublisherAction.class);
    private final ExcelConfiguration _configuration;
    private final Column[] _columns;
    private final String _relationshipId;
    private final XSSFReader _xssfReader;

    public XlsxRowPublisherAction(ExcelConfiguration configuration, Column[] columns, String relationshipId, XSSFReader xssfReader) {
        this._configuration = configuration;
        this._columns = columns;
        this._relationshipId = relationshipId;
        this._xssfReader = xssfReader;
    }

    /*
     * Loose catch block
     */
    public void run(final RowPublisher publisher) throws Exception {
        InputStream sheetData = this._xssfReader.getSheet(this._relationshipId);
        XlsxRowCallback rowCallback = new XlsxRowCallback(){

            @Override
            public boolean row(int rowNumber, List<String> values, List<Style> styles) {
                int zeroBasedLineNumber;
                if (XlsxRowPublisherAction.this._configuration.getColumnNameLineNumber() != 0 && rowNumber <= (zeroBasedLineNumber = XlsxRowPublisherAction.this._configuration.getColumnNameLineNumber() - 1)) {
                    return true;
                }
                Object[] rowData = new Object[XlsxRowPublisherAction.this._columns.length];
                Style[] styleData = new Style[XlsxRowPublisherAction.this._columns.length];
                for (int i = 0; i < XlsxRowPublisherAction.this._columns.length; ++i) {
                    int columnNumber = XlsxRowPublisherAction.this._columns[i].getColumnNumber();
                    if (columnNumber < values.size()) {
                        rowData[i] = values.get(columnNumber);
                        styleData[i] = styles.get(columnNumber);
                        continue;
                    }
                    rowData[i] = null;
                    styleData[i] = Style.NO_STYLE;
                }
                return publisher.publish(rowData, styleData);
            }
        };
        XlsxSheetToRowsHandler handler = new XlsxSheetToRowsHandler(rowCallback, this._xssfReader, this._configuration);
        XMLReader sheetParser = ExcelUtils.createXmlReader();
        sheetParser.setContentHandler(handler);
        sheetParser.setErrorHandler(handler);
        try {
            sheetParser.parse(new InputSource(sheetData));
        }
        catch (XlsxStopParsingException e) {
            logger.debug("Parsing stop signal thrown");
            publisher.finished();
            FileHelper.safeClose((Object[])new Object[]{sheetData});
        }
        catch (Exception e2) {
            logger.warn("Unexpected error occurred while parsing", (Throwable)e2);
            throw e2;
            {
                catch (Throwable throwable) {
                    publisher.finished();
                    FileHelper.safeClose((Object[])new Object[]{sheetData});
                    throw throwable;
                }
            }
        }
        publisher.finished();
        FileHelper.safeClose((Object[])new Object[]{sheetData});
    }
}

