/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelDataContext;
import org.apache.metamodel.excel.ExcelDeleteBuilder;
import org.apache.metamodel.excel.ExcelDropTableBuilder;
import org.apache.metamodel.excel.ExcelInsertBuilder;
import org.apache.metamodel.excel.ExcelTableCreationBuilder;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

final class ExcelUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private final ExcelDataContext _dataContext;
    private final ExcelConfiguration _configuration;
    private boolean _sheetsModified = false;
    private Workbook _workbook;
    private Short _dateCellFormat;
    private CellStyle _dateCellStyle;

    public ExcelUpdateCallback(ExcelDataContext dataContext) {
        super((DataContext)dataContext);
        this._configuration = dataContext.getConfiguration();
        this._dataContext = dataContext;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new ExcelTableCreationBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new ExcelInsertBuilder(this, table);
    }

    protected ExcelConfiguration getConfiguration() {
        return this._configuration;
    }

    public ExcelDataContext getDataContext() {
        return this._dataContext;
    }

    protected void close() {
        if (this._workbook != null) {
            ExcelUtils.writeWorkbook(this._dataContext, this._workbook);
            this._workbook = null;
            this._dateCellFormat = null;
            this._dateCellStyle = null;
        }
        if (this._sheetsModified) {
            this._dataContext.notifyTablesModified();
            this._sheetsModified = false;
        }
    }

    protected Workbook getWorkbook(boolean streamingAllowed) {
        if (this._workbook == null || !streamingAllowed && this._workbook instanceof SXSSFWorkbook) {
            if (this._workbook != null) {
                ExcelUtils.writeWorkbook(this._dataContext, this._workbook);
            }
            this._workbook = ExcelUtils.readWorkbook(this._dataContext);
            if (streamingAllowed && this._workbook instanceof XSSFWorkbook) {
                this._workbook = new SXSSFWorkbook((XSSFWorkbook)this._workbook);
            }
        }
        return this._workbook;
    }

    protected Sheet createSheet(String name) {
        Sheet sheet = this.getWorkbook(true).createSheet(name);
        this._sheetsModified = true;
        return sheet;
    }

    protected void removeSheet(String name) {
        int index = this.getWorkbook(true).getSheetIndex(name);
        if (index != -1) {
            this.getWorkbook(true).removeSheetAt(index);
            this._sheetsModified = true;
        }
    }

    protected Row createRow(String name) {
        if (this._sheetsModified) {
            this.close();
        }
        Sheet sheet = this.getWorkbook(true).getSheet(name);
        int lastRowNum = this.getLastRowNum(sheet);
        Row row = sheet.createRow(lastRowNum + 1);
        return row;
    }

    private int getLastRowNum(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum == 0 && sheet instanceof SXSSFSheet) {
            DataSet ds = this._dataContext.query().from(sheet.getSheetName()).selectCount().execute();
            ds.next();
            Number count = (Number)ds.getRow().getValue(0);
            int columnNameLineNumber = this._configuration.getColumnNameLineNumber();
            int oneBasedResult = count.intValue() + (columnNameLineNumber == 0 ? 0 : columnNameLineNumber);
            return oneBasedResult - 1;
        }
        return lastRowNum;
    }

    public CellStyle createCellStyle() {
        Workbook workbook = this.getWorkbook(true);
        return workbook.createCellStyle();
    }

    public Font createFont() {
        Workbook workbook = this.getWorkbook(true);
        return workbook.createFont();
    }

    protected Sheet getSheet(String name) {
        return this.getWorkbook(true).getSheet(name);
    }

    public short getDateCellFormat() {
        if (this._dateCellFormat == null) {
            Workbook workbook = this.getWorkbook(true);
            this._dateCellFormat = workbook.getCreationHelper().createDataFormat().getFormat("m/d/yy h:mm");
        }
        return this._dateCellFormat;
    }

    public CellStyle getDateCellStyle() {
        if (this._dateCellStyle == null) {
            this._dateCellStyle = this.createCellStyle();
            this._dateCellStyle.setDataFormat(this.getDateCellFormat());
        }
        return this._dateCellStyle;
    }

    public short getColorIndex(Style.Color color) {
        Workbook workbook = this.getWorkbook(true);
        if (workbook instanceof HSSFWorkbook) {
            byte b;
            byte g;
            byte r;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            HSSFColor index = palette.findColor(r = this.toRgb(color.getRed()), g = this.toRgb(color.getGreen()), b = this.toRgb(color.getBlue()));
            if (index == null) {
                index = palette.findSimilarColor(r, g, b);
            }
            return index.getIndex();
        }
        throw new IllegalStateException("Unexpected workbook type: " + workbook.getClass());
    }

    private byte toRgb(int i) {
        assert (i >= 0);
        assert (i <= 255);
        if (i > 127) {
            i -= 256;
        }
        return (byte)i;
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws UnsupportedOperationException {
        return new ExcelDropTableBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws UnsupportedOperationException {
        return new ExcelDeleteBuilder(this, table);
    }
}

