/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.Iterator;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.util.FileHelper;
import org.apache.poi.ss.usermodel.Workbook;

final class XlsDataSet
extends AbstractDataSet {
    private final Iterator<org.apache.poi.ss.usermodel.Row> _rowIterator;
    private final Workbook _workbook;
    private volatile org.apache.poi.ss.usermodel.Row _row;
    private volatile boolean _closed;

    public XlsDataSet(SelectItem[] selectItems, Workbook workbook, Iterator<org.apache.poi.ss.usermodel.Row> rowIterator) {
        super(selectItems);
        this._workbook = workbook;
        this._rowIterator = rowIterator;
        this._closed = false;
    }

    public boolean next() {
        if (this._rowIterator.hasNext()) {
            this._row = this._rowIterator.next();
            return true;
        }
        this._row = null;
        this.close();
        return false;
    }

    public Row getRow() {
        if (this._closed) {
            return null;
        }
        return ExcelUtils.createRow(this._workbook, this._row, this.getHeader());
    }

    public void close() {
        super.close();
        if (!this._closed) {
            FileHelper.safeClose((Object[])new Object[]{this._workbook});
            this._closed = true;
        }
    }
}

